/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.item;

import com.teamabnormals.neapolitan.common.entity.projectile.BananaPeel;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanEntityTypeTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanSoundEvents;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BananaBunchItem
extends Item {
    public BananaBunchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43719_() == Direction.UP) {
            Level world = context.m_43725_();
            this.placeBanana(world, context.m_43720_().m_7096_(), context.m_43720_().m_7098_(), context.m_43720_().m_7094_(), context.m_7074_());
            this.handleOpening(world, context.m_43723_(), context.m_43724_(), context.m_43722_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!target.m_6095_().m_204039_(NeapolitanEntityTypeTags.UNAFFECTED_BY_SLIPPING)) {
            Level world = player.m_9236_();
            this.placeBanana(world, target.m_20185_(), target.m_20186_(), target.m_20189_(), player.m_5675_(1.0f));
            this.handleOpening(world, player, hand, stack);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6880_(stack, player, target, hand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        this.throwPeel(level, player, player.m_5686_(1.0f), player.m_5675_(1.0f));
        this.handleOpening(level, player, hand, player.m_21120_(hand));
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    private void placeBanana(Level level, double posX, double posY, double posZ, float yaw) {
        if (!level.f_46443_) {
            BananaPeel bananapeel = (BananaPeel)((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get()).m_20615_(level);
            bananapeel.m_7678_(posX, posY, posZ, yaw, 0.0f);
            level.m_7967_((Entity)bananapeel);
        }
    }

    private void throwPeel(Level level, Player player, float pitch, float yaw) {
        if (!level.f_46443_) {
            BananaPeel bananapeel = (BananaPeel)((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get()).m_20615_(level);
            bananapeel.m_7678_(player.m_20185_(), player.m_20188_() - (double)0.1f, player.m_20189_(), yaw, 0.0f);
            Vec3 vec3 = player.m_20184_();
            bananapeel.throwPeel(pitch, yaw, vec3.f_82479_, player.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_, 1.0f);
            level.m_7967_((Entity)bananapeel);
        }
    }

    private void handleOpening(Level level, Player player, InteractionHand hand, ItemStack stack) {
        if (!level.f_46443_) {
            player.m_36335_().m_41524_((Item)this, 5);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverplayerentity = (ServerPlayer)player;
                CriteriaTriggers.f_10592_.m_23682_(serverplayerentity, stack);
                serverplayerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)NeapolitanItems.BANANA.get(), 1 + level.f_46441_.m_188503_(3)));
            } else {
                ItemStack itemstack = new ItemStack((ItemLike)NeapolitanItems.BANANA.get(), 1 + level.f_46441_.m_188503_(3));
                if (!player.m_150109_().m_36054_(itemstack)) {
                    player.m_36176_(itemstack, false);
                }
            }
        }
        level.m_5594_(player, player.m_20183_(), (SoundEvent)NeapolitanSoundEvents.BANANA_BUNCH_OPEN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

