/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.registry;

import com.teamabnormals.neapolitan.core.other.NeapolitanGeneration;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="neapolitan", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NeapolitanBiomes {
    public static final ResourceKey<Biome> STRAWBERRY_FIELDS = NeapolitanBiomes.createKey("strawberry_fields");

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter carvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(STRAWBERRY_FIELDS, (Object)NeapolitanBiomes.strawberryFields((HolderGetter<PlacedFeature>)features, carvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("neapolitan", name));
    }

    private static Biome strawberryFields(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        NeapolitanGeneration.strawberryFields(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 5, 2, 6));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 3));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 6, 2, 3));
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.8f).m_47611_(0.4f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(NeapolitanBiomes.calculateSkyColor(0.8f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(OverworldBiomes.f_194839_).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

