/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing.mixin;

import fuffles.tactical_fishing.DatapackWriter;
import fuffles.tactical_fishing.TacticalFishing;
import java.io.File;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.WorldDataConfiguration;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    public abstract RecipeManager m_129894_();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"configurePackRepository(Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/world/level/DataPackConfig;ZLnet/minecraft/world/flag/FeatureFlagSet;)Lnet/minecraft/world/level/WorldDataConfiguration;"}, at={@At(value="HEAD")})
    private static void configurePackRepository(PackRepository packRepo, DataPackConfig config, boolean flag, FeatureFlagSet flagSet, CallbackInfoReturnable<WorldDataConfiguration> cbr) {
        if (((Boolean)TacticalFishing.Config.COMMON.writeDatapack.get()).booleanValue()) {
            for (RepositorySource repo : packRepo.f_10497_) {
                File tacticalFishing;
                boolean setup;
                if (!(repo instanceof FolderRepositorySource)) continue;
                FolderRepositorySource folderRepo = (FolderRepositorySource)repo;
                if (folderRepo.f_10383_ != PackSource.f_10529_) continue;
                if (!folderRepo.f_10382_.toFile().isDirectory()) {
                    folderRepo.f_10382_.toFile().mkdirs();
                }
                boolean bl = setup = !(tacticalFishing = new File(folderRepo.f_10382_.toFile(), "tactical_fishing (in-built)")).exists();
                if (setup || DatapackWriter.isPackOutdated(tacticalFishing)) {
                    long timestamp = System.currentTimeMillis();
                    if (setup) {
                        tacticalFishing.mkdir();
                    }
                    List<Recipe<?>> toUpdate = DatapackWriter.write(tacticalFishing, "tactical_fishing", SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA), "In-built fish bucket recipes for Tactical Fishing");
                    TacticalFishing.LOG.info("In-built datapack successfully created/updated in " + (double)(System.currentTimeMillis() - timestamp) / 1000.0 + "s");
                    if (toUpdate.isEmpty()) return;
                }
                TacticalFishing.LOG.info("In-built datapack up-to-date, no further actions needed");
                return;
            }
            return;
        }
        TacticalFishing.LOG.info("Skipping writing the in-built datapack as instructed in the config");
    }
}

