/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuffles.tactical_fishing.GsonUtil;
import fuffles.tactical_fishing.TacticalFishing;
import fuffles.tactical_fishing.common.item.crafting.FishingRecipe;
import fuffles.tactical_fishing.lib.ItemTags;
import fuffles.tactical_fishing.lib.RecipeSerializers;
import fuffles.tactical_fishing.lib.Resources;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    private static boolean mightBeValid(ResourceLocation key) {
        if (!key.m_135815_().endsWith("_bucket")) {
            return false;
        }
        for (ResourceLocation fluidKey : ForgeRegistries.FLUIDS.getKeys()) {
            if (!key.m_135815_().contains(fluidKey.m_135815_() + "_bucket")) continue;
            return false;
        }
        return true;
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resManager, ProfilerFiller profiler, CallbackInfo cb) {
        if (((Boolean)TacticalFishing.Config.COMMON.writeDatapack.get()).booleanValue() && ((Boolean)TacticalFishing.Config.COMMON.writeFishBucketRecipes.get()).booleanValue()) {
            for (ResourceLocation registryKey : ForgeRegistries.ITEMS.getKeys()) {
                if (!RecipeManagerMixin.mightBeValid(registryKey)) continue;
                String id = registryKey.m_135827_();
                ResourceLocation potentialFish = new ResourceLocation(id, registryKey.m_135815_().substring(0, registryKey.m_135815_().lastIndexOf("_")));
                ResourceLocation potentialRawFish = new ResourceLocation(id, "raw_" + potentialFish.m_135815_());
                Item fish = (Item)ForgeRegistries.ITEMS.getValue(potentialFish);
                if (fish == Items.f_41852_) {
                    fish = (Item)ForgeRegistries.ITEMS.getValue(potentialRawFish);
                }
                if (fish == Items.f_41852_) continue;
                FishingRecipe recipe = new FishingRecipe(new ResourceLocation("tactical_fishing", "fishing_" + registryKey.toString().replace(':', '_')), Resources.RECIPE_GROUP_FISH_BUCKETS.toString(), Ingredient.m_204132_(ItemTags.RODS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{fish.m_7968_()}), ((Item)ForgeRegistries.ITEMS.getValue(registryKey)).m_7968_());
                map.put(recipe.m_6423_(), (JsonElement)GsonUtil.newObject(obj -> {
                    obj.addProperty("type", Resources.RECIPE_SERIALIZER_FISHING.toString());
                    RecipeSerializers.FISHING.toJson((JsonObject)obj, recipe);
                }));
            }
        }
    }
}

