/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.recipe;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrustingRecipe
extends BaseRecipe {
    public final EntityType<?> entityType;
    @NotNull
    public Ingredient inputStack;
    @NotNull
    public Ingredient spawnEgg;
    @NotNull
    public Ingredient extraInputStack;
    public final String jsonModID;
    public final String jsonAnimalID;
    public final String modFolder;
    public final String fileName;
    @Nullable
    public final CompoundTag inputEntityNbt;

    public TrustingRecipe(EntityType<?> entityType, Ingredient inputStack, Ingredient spawnEgg, Ingredient extraInputStack, String jsonModID, String jsonAnimalID, String modFolder, String fileName, @Nullable CompoundTag inputEntityNbt) {
        this.entityType = entityType;
        this.inputStack = CommonUtils.safe(inputStack);
        this.spawnEgg = CommonUtils.safe(spawnEgg);
        this.extraInputStack = CommonUtils.safe(extraInputStack);
        this.jsonModID = Objects.requireNonNull(jsonModID, "jsonModID");
        this.jsonAnimalID = Objects.requireNonNull(jsonAnimalID, "jsonAnimalID");
        this.modFolder = Objects.requireNonNull(modFolder, "modFolder");
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.inputEntityNbt = inputEntityNbt;
    }

    @Override
    @NotNull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("justenoughbreeding", "trusting/" + this.modFolder + "/" + this.fileName + "/" + this.jsonModID + "/" + this.jsonAnimalID);
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JustEnoughBreeding.TRUSTING_PROVIDER_SERIALIZER.get();
    }

    @Override
    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)JustEnoughBreeding.TRUSTING_PROVIDER_TYPE.get();
    }

    public void setInputIngredient(Ingredient ingredient) {
        this.inputStack = CommonUtils.safe(ingredient);
    }

    public void setExtraInputIngredient(Ingredient ingredient) {
        this.extraInputStack = CommonUtils.safe(ingredient);
    }

    public void setSpawnEggs(Ingredient ingredient) {
        this.spawnEgg = CommonUtils.safe(ingredient);
    }

    public static class DummyRecipe
    extends TrustingRecipe {
        public DummyRecipe(String jsonModID, String jsonAnimalID, String modFolder, String fileName) {
            super(null, null, null, null, jsonModID, jsonAnimalID, modFolder, fileName, null);
        }
    }
}

