/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.utils.UnifyTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class TagMap<T> {
    private final Map<UnifyTag<T>, Set<ResourceLocation>> tagsToEntries = new HashMap<UnifyTag<T>, Set<ResourceLocation>>();
    private final Map<ResourceLocation, Set<UnifyTag<T>>> entriesToTags = new HashMap<ResourceLocation, Set<UnifyTag<T>>>();

    protected TagMap() {
    }

    public static TagMap<Item> create(Set<UnifyTag<Item>> unifyTags) {
        TagMap<Item> tagMap = new TagMap<Item>();
        unifyTags.forEach(ut -> {
            TagKey asTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ut.location());
            BuiltInRegistries.f_257033_.m_206058_(asTagKey).forEach(holder -> {
                ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)holder.m_203334_()));
                tagMap.put((UnifyTag<Item>)ut, key);
            });
        });
        return tagMap;
    }

    public static TagMap<Item> createFromItemTags(Map<ResourceLocation, Collection<Holder<Item>>> tags) {
        TagMap<Item> tagMap = new TagMap<Item>();
        for (Map.Entry<ResourceLocation, Collection<Holder<Item>>> entry : tags.entrySet()) {
            UnifyTag<Item> unifyTag = UnifyTag.item(entry.getKey());
            TagMap.fillEntries(tagMap, entry.getValue(), unifyTag, BuiltInRegistries.f_257033_);
        }
        return tagMap;
    }

    public static TagMap<Block> createFromBlockTags(Map<ResourceLocation, Collection<Holder<Block>>> tags) {
        TagMap<Block> tagMap = new TagMap<Block>();
        for (Map.Entry<ResourceLocation, Collection<Holder<Block>>> entry : tags.entrySet()) {
            UnifyTag<Block> unifyTag = UnifyTag.block(entry.getKey());
            TagMap.fillEntries(tagMap, entry.getValue(), unifyTag, BuiltInRegistries.f_256975_);
        }
        return tagMap;
    }

    private static <T> void fillEntries(TagMap<T> tagMap, Collection<Holder<T>> holders, UnifyTag<T> unifyTag, Registry<T> registry) {
        for (Holder<T> holder : holders) {
            holder.m_203543_().map(ResourceKey::m_135782_).filter(arg_0 -> registry.m_7804_(arg_0)).ifPresent(id -> tagMap.put(unifyTag, (ResourceLocation)id));
        }
    }

    public TagMap<T> filtered(Predicate<UnifyTag<T>> tagFilter, Predicate<ResourceLocation> entryFilter) {
        TagMap tagMap = new TagMap();
        this.tagsToEntries.forEach((tag, items) -> {
            if (!tagFilter.test((UnifyTag)tag)) {
                return;
            }
            items.stream().filter(entryFilter).forEach(item -> tagMap.put((UnifyTag)tag, (ResourceLocation)item));
        });
        return tagMap;
    }

    public int tagSize() {
        return this.tagsToEntries.size();
    }

    public int itemSize() {
        return this.entriesToTags.size();
    }

    public Set<ResourceLocation> getEntriesByTag(UnifyTag<T> tag) {
        return Collections.unmodifiableSet(this.tagsToEntries.getOrDefault(tag, Collections.emptySet()));
    }

    public Set<UnifyTag<T>> getTagsByEntry(ResourceLocation entry) {
        return Collections.unmodifiableSet(this.entriesToTags.getOrDefault(entry, Collections.emptySet()));
    }

    public Set<UnifyTag<T>> getTags() {
        return Collections.unmodifiableSet(this.tagsToEntries.keySet());
    }

    protected void put(UnifyTag<T> tag, ResourceLocation entry) {
        this.tagsToEntries.computeIfAbsent(tag, k -> new HashSet()).add(entry);
        this.entriesToTags.computeIfAbsent(entry, k -> new HashSet()).add(tag);
    }
}

