/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.untitledduckmod.common.config.UntitledConfig;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.RawAnimation;

public abstract class WaterfowlEntity
extends TamableAnimal
implements GeoAnimatable {
    public static final float BABY_MIN_SCALE = 0.25f;
    public static final float BABY_MAX_SCALE = 0.7f;
    public static final String EGG_LAY_TIME_TAG = "EggLayTime";
    public static final String HELD_FOOD_TICK_TAG = "HeldFoodTick";
    public static final String RANDOM_FORCE_EAT_TICK_TAG = "RandomForceEatTick";
    public static final String VARIANT_TAG = "Variant";
    public static final String BABY_SCALE_TAG = "BabyScale";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Float> BABY_SCALE = SynchedEntityData.m_135353_(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(WaterfowlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final byte ANIMATION_IDLE = 0;
    public static final byte ANIMATION_CLEAN = 1;
    public static final byte ANIMATION_DANCE = 3;
    public static final byte ANIMATION_PANIC = 4;
    public static final byte ANIMATION_EAT = 5;
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenPlay("walk");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenPlay("idle");
    protected static final RawAnimation SWIM_ANIM = RawAnimation.begin().thenPlay("swim");
    protected static final RawAnimation SWIM_IDLE_ANIM = RawAnimation.begin().thenPlay("idle_swim");
    protected static final RawAnimation PANIC_ANIM = RawAnimation.begin().thenPlay("panic");
    protected static final RawAnimation FLY_ANIM = RawAnimation.begin().thenPlay("fly");
    protected static final RawAnimation CLEAN_ANIM = RawAnimation.begin().thenPlay("clean");
    protected static final RawAnimation EAT_ANIM = RawAnimation.begin().thenPlay("eat");
    protected static final RawAnimation SIT_ANIM = RawAnimation.begin().thenPlay("sit");
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    protected int maxVariant = 2;
    protected int eggLayTime = this.getRandomLayTime();
    private int heldFoodTick = 0;
    private int randomForceEatTick = 0;
    protected boolean isFlapping;
    protected boolean panicked = false;

    protected WaterfowlEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        byte variant = this.getRandomVariant();
        float babyScale = this.getRandomBabyScale();
        this.setVariant(variant);
        this.setBabyScale(babyScale);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(BABY_SCALE, (Object)Float.valueOf(this.getRandomBabyScale()));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_(VARIANT_TAG, this.getVariant());
        tag.m_128405_(EGG_LAY_TIME_TAG, this.eggLayTime);
        tag.m_128350_(BABY_SCALE_TAG, this.getBabyScale());
        tag.m_128405_(HELD_FOOD_TICK_TAG, this.heldFoodTick);
        tag.m_128405_(RANDOM_FORCE_EAT_TICK_TAG, this.randomForceEatTick);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128445_(VARIANT_TAG));
        if (tag.m_128441_(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.m_128451_(EGG_LAY_TIME_TAG);
        }
        this.setBabyScale(tag.m_128457_(BABY_SCALE_TAG));
        this.heldFoodTick = tag.m_128451_(HELD_FOOD_TICK_TAG);
        this.randomForceEatTick = tag.m_128451_(RANDOM_FORCE_EAT_TICK_TAG);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(7.0);
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isEdibleFood(this.m_21205_())) {
            ++this.heldFoodTick;
            if (this.randomForceEatTick == 0) {
                this.randomForceEatTick = this.generateRandomForceEatTick();
            }
        } else {
            this.heldFoodTick = 0;
            this.randomForceEatTick = 0;
        }
    }

    private int generateRandomForceEatTick() {
        int min = UntitledConfig.forceEatRandomMinTick();
        int max = UntitledConfig.forceEatRandomMaxTick();
        int actualMin = Math.min(min, max);
        int actualMax = Math.max(min, max);
        return this.f_19796_.m_216339_(actualMin, actualMax);
    }

    public abstract boolean isEdibleFood(ItemStack var1);

    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public float getRandomBabyScale() {
        return this.f_19796_.m_188501_() * 0.45f + 0.25f;
    }

    public float getBabyScale() {
        return ((Float)this.f_19804_.m_135370_(BABY_SCALE)).floatValue();
    }

    public void setBabyScale(float scale) {
        this.f_19804_.m_135381_(BABY_SCALE, (Object)Float.valueOf(scale));
    }

    public byte getRandomVariant() {
        return (byte)this.f_19796_.m_188503_(this.maxVariant);
    }

    public int getRandomLayTime() {
        return this.f_19796_.m_188503_(6000) + 6000;
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public boolean isHungry() {
        return this.m_21223_() <= this.m_21233_() - 0.5f;
    }

    public void tryEating() {
        assert (!this.m_9236_().m_5776_());
        ItemStack stack = this.m_21205_();
        Item item = stack.m_41720_();
        stack.m_41774_(1);
        this.m_5496_(this.m_7866_(stack), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        if (stack.m_41619_()) {
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (this.isHungry()) {
            this.m_5634_(item.m_41473_() != null ? (float)item.m_41473_().m_38744_() : UntitledConfig.foodHealingValue());
        }
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1 || this.getAnimation() != 5;
    }

    protected abstract SoundEvent getLayEggSound();

    public abstract Item getEggItem();

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_6084_() && !this.m_6162_() && --this.eggLayTime <= 0) {
                this.m_5496_(this.getLayEggSound(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)this.getEggItem());
                this.eggLayTime = this.getRandomLayTime();
            }
            Vec3 velocity = this.m_20184_();
            if (!this.m_20096_() && velocity.f_82480_ < 0.0) {
                this.m_20256_(velocity.m_82542_(1.0, 0.6, 1.0));
            }
            this.handlePanicAnimation();
        }
        this.isFlapping = this.m_9236_().f_46443_ && !this.m_20069_() && !this.m_20096_();
    }

    protected abstract void handlePanicAnimation();

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (!(!this.m_9236_().f_46443_ || this.m_6162_() && this.m_6898_(stack))) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !this.isTamableItem(stack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(player, hand, stack);
                this.m_5634_(item.m_41473_() != null ? (float)item.m_41473_().m_38744_() : UntitledConfig.foodHealingValue());
                return InteractionResult.CONSUME;
            }
            InteractionResult actionResult = super.m_6071_(player, hand);
            if (!actionResult.m_19077_() || this.m_6162_()) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
            return actionResult;
        }
        if (this.tryTaming(player, stack)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    protected boolean tryTaming(Player player, ItemStack stack) {
        return this.isTamable(player, stack);
    }

    protected abstract boolean isTamableItem(ItemStack var1);

    protected boolean isTamable(Player player, ItemStack stack) {
        return this.isTamableItem(stack) && !this.m_21824_();
    }

    protected void m_203347_(TagKey<Fluid> fluid) {
        if (this.m_21573_().m_26576_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.04f, 0.0));
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public int getEggLayTime() {
        return this.eggLayTime;
    }

    public int getHeldFoodTick() {
        return this.heldFoodTick;
    }

    public int getRandomForceEatTick() {
        return this.randomForceEatTick;
    }

    public boolean tamedFollowOwner() {
        return true;
    }
}

