/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.mixins;

import com.ordana.spelunkery.reg.ModSoundEvents;
import com.ordana.spelunkery.utils.LevelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class PortalFluidMixin {
    @Shadow
    public Level f_19853_;
    private int fluidCooldown;
    protected boolean isInsideFluid;
    protected BlockPos fluidEntrancePos;
    protected int fluidTime;

    @Shadow
    public abstract int m_6045_();

    @Shadow
    public abstract boolean m_20159_();

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;handleNetherPortal()V", shift=At.Shift.AFTER)})
    public void insertFluidTick(CallbackInfo ci) {
        this.handlePortalFluid();
    }

    public Level level() {
        return this.f_19853_;
    }

    public void setFluidCooldown() {
        this.fluidCooldown = this.m_6045_();
    }

    public boolean isOnFluidCooldown() {
        return this.fluidCooldown > 0;
    }

    protected void processFluidCooldown() {
        if (this.isOnFluidCooldown()) {
            --this.fluidCooldown;
        }
    }

    public int getPortalWaitTime() {
        return 0;
    }

    public void handleInsideFluid(BlockPos pos) {
        if (this.isOnFluidCooldown()) {
            this.setFluidCooldown();
        } else {
            if (!this.level().f_46443_ && !pos.equals((Object)this.fluidEntrancePos)) {
                this.fluidEntrancePos = pos.m_7949_();
            }
            this.isInsideFluid = true;
        }
    }

    protected void handlePortalFluid() {
        if (this.level() instanceof ServerLevel) {
            int i = this.getPortalWaitTime();
            if (this.isInsideFluid) {
                if (!this.m_20159_() && this.fluidTime++ >= i) {
                    this.fluidTime = i;
                    this.setFluidCooldown();
                    Entity entity = (Entity)this;
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        LevelHelper.teleportToSpawnPosition(player);
                    } else {
                        LevelHelper.teleportToWorldspawn(this.f_19853_, entity);
                    }
                    entity.m_5496_((SoundEvent)ModSoundEvents.PORTAL_FLUID_TELEPORT.get(), 1.0f, 1.0f);
                }
                this.isInsideFluid = false;
            } else {
                if (this.fluidTime > 0) {
                    this.fluidTime -= 4;
                }
                if (this.fluidTime < 0) {
                    this.fluidTime = 0;
                }
            }
            this.processFluidCooldown();
        }
    }
}

