/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.ShapeType;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class StartCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public StartCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        if (arguments.size() > 0) {
            Optional world = arguments.next().flatMap(arg -> Input.tryWorld(this.chunky, arg));
            if (world.isPresent()) {
                this.chunky.getSelection().world((World)world.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 1) {
            Optional shape = arguments.next().flatMap(Input::tryShape);
            if (shape.isPresent()) {
                this.chunky.getSelection().shape((String)shape.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 2) {
            Optional<Double> centerX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit(c));
            Optional<Double> centerZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit(c));
            if (centerX.isPresent() && centerZ.isPresent()) {
                this.chunky.getSelection().center(centerX.get(), centerZ.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 4) {
            Optional<Double> radiusX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit(r));
            if (radiusX.isPresent()) {
                this.chunky.getSelection().radius(radiusX.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 5) {
            Optional<Double> radiusZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit(r));
            if (radiusZ.isPresent()) {
                this.chunky.getSelection().radiusZ(radiusZ.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        Selection current = this.chunky.getSelection().build();
        if (this.chunky.getGenerationTasks().containsKey(current.world().getName())) {
            sender.sendMessagePrefixed("format_started_already", current.world().getName());
            return;
        }
        if (current.radiusX() > this.chunky.getLimit()) {
            sender.sendMessagePrefixed("format_start_limit", Formatting.number(this.chunky.getLimit()));
            return;
        }
        Runnable startAction = () -> {
            GenerationTask generationTask = new GenerationTask(this.chunky, current);
            this.chunky.getGenerationTasks().put(current.world().getName(), generationTask);
            this.chunky.getScheduler().runTask(generationTask);
            sender.sendMessagePrefixed("format_start", current.world().getName(), Translator.translate("shape_" + current.shape(), new Object[0]), Formatting.number(current.centerX()), Formatting.number(current.centerZ()), Formatting.radius(current));
        };
        if (this.chunky.getTaskLoader().loadTask(current.world()).filter(task -> !task.isCancelled()).isPresent()) {
            this.chunky.setPendingAction(sender, startAction);
            sender.sendMessagePrefixed("format_start_confirm", "/chunky continue", "/chunky confirm");
        } else {
            startAction.run();
        }
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        if (arguments.size() == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        if (arguments.size() == 2) {
            return ShapeType.all();
        }
        return List.of();
    }
}

