/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderProxy;
import com.seibel.distanthorizons.core.config.listeners.IConfigListener;
import com.seibel.distanthorizons.core.util.TimerUtil;
import java.util.Timer;
import java.util.TimerTask;

public class ReloadLodsConfigEventHandler
implements IConfigListener {
    public static ReloadLodsConfigEventHandler DELAYED_INSTANCE = new ReloadLodsConfigEventHandler(2000L);
    public static ReloadLodsConfigEventHandler INSTANT_INSTANCE = new ReloadLodsConfigEventHandler(0L);
    private final long timeoutInMs;
    private Timer cacheClearingTimer;

    public ReloadLodsConfigEventHandler(long timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    @Override
    public void onConfigValueSet() {
        if (this.timeoutInMs > 0L) {
            this.refreshRenderDataAfterTimeout();
        } else {
            ReloadLodsConfigEventHandler.clearRenderDataCache();
        }
    }

    private synchronized void refreshRenderDataAfterTimeout() {
        if (this.cacheClearingTimer != null) {
            this.cacheClearingTimer.cancel();
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ReloadLodsConfigEventHandler.clearRenderDataCache();
            }
        };
        this.cacheClearingTimer = TimerUtil.CreateTimer("RenderCacheClearConfigTimer");
        this.cacheClearingTimer.schedule(timerTask, this.timeoutInMs);
    }

    private static void clearRenderDataCache() {
        IDhApiRenderProxy renderProxy = DhApi.Delayed.renderProxy;
        if (renderProxy != null) {
            renderProxy.clearRenderDataCache();
        }
    }
}

