/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.item;

import com.molybdenum.alloyed.Alloyed;
import com.molybdenum.alloyed.common.registry.ModCompat;
import com.molybdenum.alloyed.common.registry.ModItems;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModCreativeModeTab {
    private static final DeferredRegister<CreativeModeTab> REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"alloyed");
    public static final RegistryObject<CreativeModeTab> MAIN_TAB = REGISTER.register("main_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.alloyed.main_group")).m_257737_(() -> ModItems.STEEL_INGOT.asStack()).m_257501_((CreativeModeTab.DisplayItemsGenerator)new DisplayItemsGenerator()).m_257652_());

    public static void register(IEventBus modEventBus) {
        REGISTER.register(modEventBus);
    }

    public static void registerLang() {
        Alloyed.REGISTRATE.addRawLang("itemGroup.alloyed.main_tab", "Create: Alloyed");
    }

    private static class DisplayItemsGenerator
    implements CreativeModeTab.DisplayItemsGenerator {
        private DisplayItemsGenerator() {
        }

        private static Predicate<Item> hideCompatItemPredicate() {
            ReferenceOpenHashSet hiddenItems = new ReferenceOpenHashSet();
            for (ModCompat mod : ModCompat.values()) {
                List<ItemProviderEntry<?>> entries = mod.getEntries();
                for (ItemProviderEntry<?> entry : entries) {
                    if (!mod.shouldHide().booleanValue()) continue;
                    hiddenItems.add(entry.m_5456_());
                }
            }
            return ((Set)hiddenItems)::contains;
        }

        public void m_257865_(CreativeModeTab.ItemDisplayParameters pParameters, CreativeModeTab.Output pOutput) {
            Predicate<Item> shouldHide = DisplayItemsGenerator.hideCompatItemPredicate();
            LinkedList<Item> items = new LinkedList<Item>();
            items.addAll(this.getBlocksUnless(shouldHide));
            items.addAll(this.getItemsUnless(shouldHide));
            for (Item item : items) {
                pOutput.m_246342_(new ItemStack((ItemLike)item));
            }
        }

        private List<Item> getBlocksUnless(Predicate<Item> shouldHidePredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Alloyed.REGISTRATE.getAll(Registries.f_256747_)) {
                Item item = ((Block)entry.get()).m_5456_();
                if (item == Items.f_41852_ || shouldHidePredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<Item> getItemsUnless(Predicate<Item> shouldHidePredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : Alloyed.REGISTRATE.getAll(Registries.f_256913_)) {
                Item item = (Item)entry.get();
                if (item instanceof BlockItem || shouldHidePredicate.test(item)) continue;
                items.add(item);
            }
            return items;
        }
    }
}

