/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.molybdenum.alloyed.client.registry.ModPartialModels;
import com.molybdenum.alloyed.common.content.extensions.BeltBlockEntityExtension;
import com.molybdenum.alloyed.common.content.extensions.BeltModelExtension;
import com.molybdenum.alloyed.common.registry.ModSpriteShifts;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltModel;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeltModel.class})
public class BeltModelMixin
implements BeltModelExtension {
    @Inject(method={"getQuads"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true, remap=false)
    private void handleAlloyedCasingRendering(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType, CallbackInfoReturnable<List<BakedQuad>> cir, @Local List quads, @Local(ordinal=0) boolean cover) {
        BeltBlockEntityExtension.AlloyedCasingType alloyedType = (BeltBlockEntityExtension.AlloyedCasingType)((Object)extraData.get(ALLOYED_CASING_PROPERTY));
        if (alloyedType == BeltBlockEntityExtension.AlloyedCasingType.NONE) {
            return;
        }
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads);
        PartialModel belt_cover_x = ModPartialModels.STEEL_BELT_COVER_X;
        PartialModel belt_cover_z = ModPartialModels.STEEL_BELT_COVER_Z;
        SpriteShiftEntry belt_casing = ModSpriteShifts.STEEL_BELT_CASING;
        if (alloyedType == BeltBlockEntityExtension.AlloyedCasingType.BRONZE) {
            belt_cover_x = ModPartialModels.BRONZE_BELT_COVER_X;
            belt_cover_z = ModPartialModels.BRONZE_BELT_COVER_Z;
            belt_casing = ModSpriteShifts.BRONZE_BELT_CASING;
        }
        if (cover) {
            boolean alongX = ((Direction)state.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X;
            BakedModel coverModel = (alongX ? belt_cover_x : belt_cover_z).get();
            newQuads.addAll(coverModel.m_213637_(state, side, rand));
        }
        for (int i = 0; i < newQuads.size(); ++i) {
            BakedQuad quad = (BakedQuad)newQuads.get(i);
            TextureAtlasSprite original = quad.m_173410_();
            if (original != belt_casing.getOriginal()) continue;
            BakedQuad newQuad = BakedQuadHelper.clone((BakedQuad)quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU((int[])vertexData, (int)vertex);
                float v = BakedQuadHelper.getV((int[])vertexData, (int)vertex);
                BakedQuadHelper.setU((int[])vertexData, (int)vertex, (float)belt_casing.getTargetU(u));
                BakedQuadHelper.setV((int[])vertexData, (int)vertex, (float)belt_casing.getTargetV(v));
            }
            newQuads.set(i, newQuad);
        }
        cir.setReturnValue(newQuads);
    }

    @Inject(method={"getParticleIcon"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void returnAlloyedSpritesIfNeeded(ModelData data, CallbackInfoReturnable<TextureAtlasSprite> cir) {
        if (!data.has(ALLOYED_CASING_PROPERTY)) {
            return;
        }
        if (data.get(ALLOYED_CASING_PROPERTY) == BeltBlockEntityExtension.AlloyedCasingType.STEEL) {
            cir.setReturnValue((Object)ModSpriteShifts.STEEL_CASING.getOriginal());
            cir.cancel();
        }
        if (data.get(ALLOYED_CASING_PROPERTY) == BeltBlockEntityExtension.AlloyedCasingType.BRONZE) {
            cir.setReturnValue((Object)ModSpriteShifts.BRONZE_CASING.getOriginal());
            cir.cancel();
        }
    }
}

