/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.cc;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.cc.CCBlockEntity;
import com.tom.morewires.compat.cc.CCWireDefinition;
import com.tom.morewires.compat.cc.ICCTile;
import com.tom.morewires.tile.IConnector;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CCModemConnectorBlockEntity
extends CCBlockEntity
implements IConnector,
IEBlockInterfaces.IBlockBounds,
ICCTile {
    protected GlobalWireNetwork globalNet;
    private boolean isUnloaded = false;
    private static final String NBT_PERIPHERAL_ENABLED = "PeirpheralAccess";
    private boolean invalidPeripheral;
    private boolean peripheralAccessAllowed;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(PlatformHelper.get().createPeripheralAccess((BlockEntity)this, x -> this.queueRefreshPeripheral()));
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final WiredModemElement cable = new CableElement();
    private LazyOptional<WiredElement> elementCap;
    private final WiredNode node = this.cable.getNode();
    private final TickScheduler.Token tickToken = new TickScheduler.Token((BlockEntity)this);
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule((TickScheduler.Token)this.tickToken)), this.cable, this.peripheral, this){

        public Vec3 getPosition() {
            Direction dir = CCModemConnectorBlockEntity.this.getFacing();
            return Vec3.m_82512_((Vec3i)(dir == null ? CCModemConnectorBlockEntity.this.m_58899_() : CCModemConnectorBlockEntity.this.m_58899_().m_121945_(dir)));
        }
    };
    private LazyOptional<IPeripheral> modemCap;

    public CCModemConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockState getState() {
        return this.m_58900_();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        LocalWireNetwork local = this.globalNet.getNullableLocalNet(new ConnectionPoint(this.f_58858_, 0));
        if (local != null && !local.getConnections(this.f_58858_).isEmpty()) {
            return false;
        }
        return MoreImmersiveWires.CC_WIRE.simple().wireType == cableType;
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    public void m_142339_(Level worldIn) {
        super.m_142339_(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork((Level)worldIn);
    }

    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.m_6596_();
    }

    public BlockPos getPosition() {
        return this.f_58858_;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload((GlobalWireNetwork)this.globalNet, (IImmersiveConnectable)this);
        this.isUnloaded = true;
        this.onRemove();
    }

    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad((IImmersiveConnectable)this, (Level)this.f_58857_);
        this.isUnloaded = false;
    }

    public void setRemovedIE() {
        ConnectorBlockEntityHelper.remove((Level)this.f_58857_, (IImmersiveConnectable)this);
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.isUnloaded) {
            this.setRemovedIE();
        }
        this.onRemove();
    }

    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().m_122424_();
        double lengthFromHalf = 0.8125 - type.getRenderDiameter() / 2.0 - 0.5;
        return new Vec3(0.5 + lengthFromHalf * (double)side.m_122429_(), 0.5 + lengthFromHalf * (double)side.m_122430_(), 0.5 + lengthFromHalf * (double)side.m_122431_());
    }

    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return Shapes.m_83110_((VoxelShape)EnergyConnectorBlockEntity.getConnectorBounds((Direction)this.getFacing(), (float)0.8125f), (VoxelShape)ModemShapes.getBounds((Direction)this.getFacing()));
    }

    @Override
    public Level getLevelNonnull() {
        return this.f_58857_;
    }

    private void onRemove() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.modem.removed();
            this.onRemove();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        this.modemCap = CapabilityUtil.invalidate(this.modemCap);
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    @Override
    public void onNeighbourChange(BlockPos neighbour) {
        Direction dir = this.getFacing();
        if (neighbour.equals((Object)this.m_58899_().m_121945_(dir)) && !this.m_58900_().m_60710_((LevelReader)this.m_58904_(), this.m_58899_())) {
            Block.m_49840_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)CCWireDefinition.CC_MODEM_CONNECTOR.get()));
            this.m_58904_().m_7471_(this.m_58899_(), false);
            return;
        }
        this.onNeighbourTileEntityChange(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(BlockPos neighbour) {
        super.onNeighbourTileEntityChange(neighbour);
        if (!this.f_58857_.f_46443_ && this.peripheralAccessAllowed) {
            Direction facing = this.getFacing();
            if (this.m_58899_().m_121945_(facing).equals((Object)neighbour)) {
                this.queueRefreshPeripheral();
            }
        }
    }

    private void queueRefreshPeripheral() {
        if (this.invalidPeripheral) {
            return;
        }
        this.invalidPeripheral = true;
        TickScheduler.schedule((TickScheduler.Token)this.tickToken);
    }

    private void refreshPeripheral() {
        this.invalidPeripheral = false;
        if (this.f_58857_ != null && !this.m_58901_() && this.peripheral.attach(this.f_58857_, this.m_58899_(), this.getFacing())) {
            this.updateConnectedPeripherals();
        }
    }

    @Override
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        if (!this.canAttachPeripheral()) {
            return InteractionResult.FAIL;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        this.togglePeripheralAccess();
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equal((Object)newName, (Object)oldName)) {
            if (oldName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.computercraft.wired_modem.peripheral_disconnected", (Object[])new Object[]{ChatHelpers.copy((String)oldName)}), false);
            }
            if (newName != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.computercraft.wired_modem.peripheral_connected", (Object[])new Object[]{ChatHelpers.copy((String)newName)}), false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.peripheralAccessAllowed = nbt.m_128471_(NBT_PERIPHERAL_ENABLED);
        this.peripheral.read(nbt, "");
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        this.peripheral.write(nbt, "");
        super.m_183515_(nbt);
    }

    private void updateBlockState() {
        BlockState state = this.m_58900_();
        boolean modemOn = this.modem.getModemState().isOpen();
        boolean peripheralOn = this.peripheralAccessAllowed;
        if ((Boolean)state.m_61143_((Property)WiredModemFullBlock.MODEM_ON) == modemOn && (Boolean)state.m_61143_((Property)WiredModemFullBlock.PERIPHERAL_ON) == peripheralOn) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)WiredModemFullBlock.MODEM_ON, (Comparable)Boolean.valueOf(modemOn))).m_61124_((Property)WiredModemFullBlock.PERIPHERAL_ON, (Comparable)Boolean.valueOf(peripheralOn)));
    }

    @Override
    public void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.invalidPeripheral) {
            this.refreshPeripheral();
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            if (this.peripheralAccessAllowed) {
                this.peripheral.attach(this.f_58857_, this.f_58858_, this.getFacing());
                this.updateConnectedPeripherals();
            }
        }
    }

    void modemChanged() {
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (!this.canAttachPeripheral() && this.peripheralAccessAllowed) {
            this.peripheralAccessAllowed = false;
            this.peripheral.detach();
            this.node.updatePeripherals(Collections.emptyMap());
            this.m_6596_();
            this.updateBlockState();
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            this.peripheral.attach(this.f_58857_, this.m_58899_(), this.getFacing());
            if (!this.peripheral.hasPeripheral()) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.peripheral.toMap());
        } else {
            this.peripheral.detach();
            this.peripheralAccessAllowed = false;
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        Map peripherals = this.peripheral.toMap();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            if (side != null && this.getFacing() != side) {
                return LazyOptional.empty();
            }
            if (this.modemCap == null) {
                this.modemCap = LazyOptional.of(() -> this.modem);
            }
            return this.modemCap.cast();
        }
        return super.getCapability(capability, side);
    }

    private boolean canAttachPeripheral() {
        return true;
    }

    @Override
    public WiredElement getElement() {
        return this.cable;
    }

    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)MoreImmersiveWires.CC_WIRE.simple().NET_ID);
    }

    private class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        public Level getLevel() {
            return CCModemConnectorBlockEntity.this.m_58904_();
        }

        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)CCModemConnectorBlockEntity.this.m_58899_());
        }

        protected void attachPeripheral(String name, IPeripheral peripheral) {
            CCModemConnectorBlockEntity.this.modem.attachPeripheral(name, peripheral);
        }

        protected void detachPeripheral(String name) {
            CCModemConnectorBlockEntity.this.modem.detachPeripheral(name);
        }
    }
}

