/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.PurpoidSize;
import com.teamabnormals.endergetic.common.network.entity.S2CEnablePurpoidFlash;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.other.EEPlayableEndimations;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class PurpoidAttackGoal
extends Goal {
    private final Purpoid purpoid;
    @Nullable
    private Path path;
    private int delayCounter;
    private int teleportToTargetTimer;

    public PurpoidAttackGoal(Purpoid purpoid) {
        this.purpoid = purpoid;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Purpoid purpoid = this.purpoid;
        if (purpoid.isNoEndimationPlaying() && !purpoid.getTeleportController().isTeleporting() && PurpoidAttackGoal.shouldFollowTarget(purpoid, false)) {
            this.path = purpoid.m_21573_().m_6570_((Entity)purpoid.m_5448_(), 0);
            return this.path != null;
        }
        return false;
    }

    public void m_8056_() {
        Purpoid purpoid = this.purpoid;
        purpoid.m_21573_().m_26536_(this.path, 2.25);
        purpoid.m_21561_(true);
        this.delayCounter = 0;
        this.teleportToTargetTimer = 0;
    }

    public boolean m_8045_() {
        Purpoid purpoid = this.purpoid;
        return PurpoidAttackGoal.shouldFollowTarget(purpoid, false) && purpoid.m_21573_().m_26572_();
    }

    public void m_8037_() {
        Purpoid purpoid = this.purpoid;
        if (!purpoid.isBoosting()) {
            purpoid.setBoostingTicks(5);
        }
        this.delayCounter = Math.max(this.delayCounter - 1, 0);
        LivingEntity target = purpoid.m_5448_();
        double distanceToTargetSq = purpoid.m_20280_((Entity)target);
        RandomSource random = purpoid.m_217043_();
        if (this.delayCounter <= 0 && random.m_188501_() < 0.05f) {
            this.delayCounter = 15 + random.m_188503_(11);
            PathNavigation pathNavigator = purpoid.m_21573_();
            if (distanceToTargetSq >= 9.0) {
                Path path = pathNavigator.m_7864_(purpoid.getSize() == PurpoidSize.NORMAL ? PurpoidAttackGoal.findAirPosAboveTarget(purpoid.m_9236_(), target) : target.m_20183_().m_6630_(random.m_188503_(3)), 0);
                if (path == null || !pathNavigator.m_26536_(path, 2.25)) {
                    this.delayCounter += 20;
                }
            } else {
                purpoid.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 2.25);
            }
        }
        boolean small = purpoid.getSize() == PurpoidSize.PURP;
        float width = purpoid.m_20205_() * (small ? 3.0f : 2.0f);
        double reachRange = width * width + target.m_20205_();
        if (distanceToTargetSq <= reachRange) {
            if (small) {
                if (purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_TELEFRAG) && purpoid.getAnimationTick() == 5) {
                    target.m_6469_(purpoid.m_9236_().m_269111_().m_269333_((LivingEntity)purpoid), (float)purpoid.m_21133_(Attributes.f_22281_));
                    double targetX = target.m_20185_();
                    double targetY = target.m_20186_();
                    double targetZ = target.m_20189_();
                    for (int i = 0; i < 16; ++i) {
                        double randomZ;
                        double randomY;
                        double randomX = targetX + (random.m_188500_() - 0.5) * 32.0;
                        if (!target.m_20984_(randomX, randomY = targetY + (double)(random.m_188503_(33) - 16), randomZ = targetZ + (random.m_188500_() - 0.5) * 32.0, false)) continue;
                        if (target instanceof ServerPlayer) {
                            EndergeticExpansion.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)target), (Object)new S2CEnablePurpoidFlash());
                        }
                        break;
                    }
                } else if (purpoid.isNoEndimationPlaying()) {
                    NetworkUtil.setPlayingAnimation((Entity)purpoid, (PlayableEndimation)EEPlayableEndimations.PURPOID_TELEFRAG);
                }
            } else {
                purpoid.m_20329_((Entity)target);
            }
            this.teleportToTargetTimer = 0;
        } else if (small && distanceToTargetSq >= 2.0 && distanceToTargetSq <= 1024.0 && random.m_188501_() < 0.1f && ++this.teleportToTargetTimer >= 10) {
            double targetX = target.m_20185_();
            double targetY = target.m_20186_();
            double targetZ = target.m_20189_();
            Level level = purpoid.m_9236_();
            EntityDimensions dimensions = purpoid.m_6972_(purpoid.m_20089_());
            double predictedXDisplacement = Mth.m_14008_((double)(target.m_20184_().m_7096_() * 57.0), (double)-7.0, (double)7.0);
            double predictedZDisplacement = Mth.m_14008_((double)(target.m_20184_().m_7094_() * 57.0), (double)-7.0, (double)7.0);
            for (int i = 0; i < 16; ++i) {
                double randomZ;
                double randomX = targetX + predictedXDisplacement;
                double randomY = targetY + random.m_216328_(0.0, 2.0);
                if (!level.m_45772_(dimensions.m_20384_(randomX, randomY, randomZ = targetZ + predictedZDisplacement))) continue;
                purpoid.getTeleportController().beginTeleportation(purpoid, new Vec3(randomX, randomY, randomZ), false);
                purpoid.m_21573_().m_26573_();
                break;
            }
            this.teleportToTargetTimer = 0;
        }
    }

    public void m_8041_() {
        Purpoid purpoid = this.purpoid;
        LivingEntity livingentity = purpoid.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            purpoid.m_6710_(null);
        }
        purpoid.m_21561_(false);
        purpoid.m_21573_().m_26573_();
    }

    public static boolean shouldFollowTarget(Purpoid purpoid, boolean near) {
        LivingEntity attackTarget = purpoid.m_5448_();
        return attackTarget != null && attackTarget.m_6084_() && attackTarget.m_146862_(e -> e instanceof Purpoid) == near && !purpoid.m_20159_() && (!(attackTarget instanceof Player) || !attackTarget.m_5833_() && !((Player)attackTarget).m_7500_());
    }

    public static BlockPos findAirPosAboveTarget(Level world, LivingEntity target) {
        BlockPos.MutableBlockPos mutable = target.m_20183_().m_122032_();
        int maxHeight = target.m_217043_().m_188503_(3) + 4;
        for (int y = 0; y < maxHeight; ++y) {
            mutable.m_122184_(0, 1, 0);
            if (world.m_46859_((BlockPos)mutable)) continue;
            mutable.m_122184_(0, -1, 0);
            break;
        }
        return mutable;
    }

    public boolean m_183429_() {
        return true;
    }
}

