/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.petrolpark.PetrolparkTags;
import com.petrolpark.contamination.Contaminable;
import com.petrolpark.contamination.Contaminant;
import com.petrolpark.contamination.FluidContamination;
import com.petrolpark.contamination.IncontaminableContamination;
import com.petrolpark.contamination.ItemContamination;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class Contaminables {
    protected static final List<Contaminable<?, ?>> CONTAMINABLES = new ArrayList();
    public static final Contaminable.GenericContaminable GENERIC = new Contaminable.GenericContaminable();
    public static final Contaminable.GenericContaminable NOT = new Contaminable.GenericContaminable(){

        public IncontaminableContamination getContamination(Object stack) {
            return IncontaminableContamination.INSTANCE;
        }
    };
    public static final Contaminable<Item, ItemStack> ITEM = new Contaminable<Item, ItemStack>(){

        @Override
        public boolean isContaminable(Item object) {
            return object instanceof BlockItem ? PetrolparkTags.Items.CONTAMINABLE_BLOCKS.matches(object) : !PetrolparkTags.Items.INCONTAMINABLE.matches(object);
        }

        @Override
        public boolean isContaminableStack(ItemStack stack) {
            return !stack.m_41619_() && this.isContaminable(stack.m_41720_());
        }

        public ItemContamination getContamination(Object stack) {
            ItemStack itemStack;
            if (stack instanceof ItemStack && this.isContaminableStack(itemStack = (ItemStack)stack)) {
                return new ItemContamination(itemStack);
            }
            return null;
        }

        @Override
        public Set<Contaminant> getIntrinsicContaminants(Item object) {
            return object.m_204114_().m_203616_().map(Contaminant::getFromIntrinsicTag).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public Set<Contaminant> getShownIfAbsentContaminants(Item object) {
            return object.m_204114_().m_203616_().map(Contaminant::getFromShowIfAbsentTag).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    };
    public static final Contaminable<Fluid, FluidStack> FLUID = new Contaminable<Fluid, FluidStack>(){

        @Override
        public boolean isContaminable(Fluid object) {
            return !PetrolparkTags.Fluids.INCONTAMINABLE.matches(object);
        }

        @Override
        public boolean isContaminableStack(FluidStack stack) {
            return !stack.isEmpty() && this.isContaminable(stack.getFluid());
        }

        public FluidContamination getContamination(Object stack) {
            FluidStack fluidStack;
            if (stack instanceof FluidStack && this.isContaminableStack(fluidStack = (FluidStack)stack)) {
                return new FluidContamination(fluidStack);
            }
            return null;
        }

        @Override
        public Set<Contaminant> getIntrinsicContaminants(Fluid object) {
            return ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)object).m_203616_().map(Contaminant::getFromIntrinsicTag).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public Set<Contaminant> getShownIfAbsentContaminants(Fluid object) {
            return ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)object).m_203616_().map(Contaminant::getFromShowIfAbsentTag).filter(Objects::nonNull).collect(Collectors.toSet());
        }
    };

    public static void register(Contaminable<?, ?> contaminable) {
        CONTAMINABLES.add(contaminable);
    }

    public static Stream<Contaminable<?, ?>> streamContaminables() {
        return CONTAMINABLES.stream();
    }

    static {
        Contaminables.register(GENERIC);
        Contaminables.register(NOT);
        Contaminables.register(ITEM);
        Contaminables.register(FLUID);
    }
}

