/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.contamination;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.contamination.IntrinsicContaminants;
import com.petrolpark.util.GraphHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Contaminant {
    public static final Codec<Contaminant> CODEC = ExtraCodecs.m_216185_((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("preservationProportion").forGetter(Contaminant::getPreservationProportion), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("color").forGetter(Contaminant::getColor), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("absentColor").forGetter(Contaminant::getAbsentColor), (App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("children").forGetter(c -> c.childResourceLocations)).apply((Applicative)instance, Contaminant::new)));
    public final double preservationProportion;
    public final int color;
    public final int absentColor;
    private final List<ResourceLocation> childResourceLocations;
    protected Set<Contaminant> children = new HashSet<Contaminant>();
    protected Set<Contaminant> parents = new HashSet<Contaminant>();
    protected ResourceLocation rl;
    protected String descriptionId;
    protected String absentDescriptionId;
    protected Set<Contaminant> childrenView = null;
    protected Set<Contaminant> parentsView = null;

    public static Contaminant get(ResourceLocation resourceLocation) {
        return (Contaminant)PetrolparkRegistries.getDataRegistry(PetrolparkRegistries.Keys.CONTAMINANT).m_7745_(resourceLocation);
    }

    public static Contaminant get(RegistryAccess registries, ResourceLocation resourceLocation) {
        return (Contaminant)registries.m_255025_(PetrolparkRegistries.Keys.CONTAMINANT).m_255043_(ResourceKey.m_135785_(PetrolparkRegistries.Keys.CONTAMINANT, (ResourceLocation)resourceLocation)).m_203334_();
    }

    public static Contaminant getFromIntrinsicTag(TagKey<?> tagKey) {
        return Contaminant.getFromTag(tagKey, "intrinsic");
    }

    public static Contaminant getFromShowIfAbsentTag(TagKey<?> tagKey) {
        return Contaminant.getFromTag(tagKey, "show_if_absent");
    }

    public static Contaminant getFromTag(TagKey<?> tagKey, String pathSuffix) {
        ResourceLocation rl = tagKey.f_203868_();
        String[] path = rl.m_135815_().split("/");
        if (!path[0].equals("contaminant") || !path[2].equals(pathSuffix)) {
            return null;
        }
        return (Contaminant)PetrolparkRegistries.getDataRegistry(PetrolparkRegistries.Keys.CONTAMINANT).m_7745_(new ResourceLocation(rl.m_135827_(), path[1]));
    }

    public Contaminant(double preservationProportion, int color, int absentColor, List<ResourceLocation> childResourceLocations) {
        this.preservationProportion = preservationProportion;
        this.color = color;
        this.absentColor = absentColor;
        this.childResourceLocations = childResourceLocations;
    }

    public double getPreservationProportion() {
        return this.preservationProportion;
    }

    public boolean isPreserved(double proportion) {
        if (this.preservationProportion == 0.0) {
            return proportion > 0.0;
        }
        return proportion >= this.preservationProportion;
    }

    public int getColor() {
        return this.color;
    }

    public int getAbsentColor() {
        return this.absentColor;
    }

    public Set<Contaminant> getChildren() {
        if (this.childrenView == null) {
            this.childrenView = Collections.unmodifiableSet(this.children);
        }
        return this.childrenView;
    }

    public Set<Contaminant> getParents() {
        if (this.parentsView == null) {
            this.parentsView = Collections.unmodifiableSet(this.parents);
        }
        return this.parentsView;
    }

    @Deprecated
    public ResourceLocation getLocation() {
        return this.getLocation((RegistryAccess)ServerLifecycleHooks.getCurrentServer().m_206579_());
    }

    public ResourceLocation getLocation(RegistryAccess registryAccess) {
        if (this.rl == null) {
            this.rl = registryAccess.m_175515_(PetrolparkRegistries.Keys.CONTAMINANT).m_7981_((Object)this);
        }
        return this.rl;
    }

    public int compareTo(Contaminant contaminant) {
        return this.getLocation().compareTo(contaminant.getLocation());
    }

    public Component getName() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"contaminant", (ResourceLocation)this.getLocation());
        }
        return Component.m_237115_((String)this.descriptionId);
    }

    public Component getNameColored() {
        return this.getName().m_6881_().m_130948_(Style.f_131099_.m_178520_(this.color));
    }

    public Component getAbsentName() {
        if (this.absentDescriptionId == null) {
            this.absentDescriptionId = Util.m_137492_((String)"contaminant", (ResourceLocation)this.getLocation()) + ".absent";
        }
        return Component.m_237115_((String)this.absentDescriptionId);
    }

    public Component getAbsentNameColored() {
        return this.getAbsentName().m_6881_().m_130948_(Style.f_131099_.m_178520_(this.absentColor));
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public final RegistryAccess registryAccess;

        public ReloadListener(RegistryAccess registryAccess) {
            this.registryAccess = registryAccess;
        }

        public void m_6213_(ResourceManager resourceManager) {
            Registry registry = this.registryAccess.m_175515_(PetrolparkRegistries.Keys.CONTAMINANT);
            registry.forEach(parent -> {
                ResourceLocation parentName = registry.m_7981_(parent);
                parent.childResourceLocations.forEach(childName -> {
                    Contaminant child = (Contaminant)registry.m_6612_(childName).orElseThrow(() -> new JsonSyntaxException(String.format("Error in Contaminant %s: no such child '%s'", parentName.toString(), childName.toString())));
                    child.parents.add((Contaminant)parent);
                    parent.children.add(child);
                });
            });
            registry.forEach(parent -> {
                ResourceLocation parentName = registry.m_7981_(parent);
                try {
                    for (Contaminant descendant : GraphHelper.getAllDescendants(parent, c -> c.children)) {
                        parent.children.add(descendant);
                        descendant.parents.add((Contaminant)parent);
                    }
                }
                catch (GraphHelper.CircularReferenceException e) {
                    throw new JsonSyntaxException(String.format("Contaminant %s is its own descendant. Replace the circular reference with a single Contaminant", parentName));
                }
            });
            IntrinsicContaminants.clear();
        }
    }
}

