/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.util.Pair;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.GsonAdapterFactory;
import net.minecraft.world.level.storage.loot.SerializerType;
import net.minecraftforge.registries.IForgeRegistry;

public class ForgeRegistryObjectGSONAdapter<E, T extends SerializerType<E>>
implements JsonDeserializer<E>,
JsonSerializer<E> {
    private final ResourceKey<Registry<T>> registryKey;
    private final String elementName;
    private final String typeKey;
    private final Function<E, T> typeGetter;
    @Nullable
    private final Supplier<T> defaultType;
    @Nullable
    private final Pair<Supplier<T>, GsonAdapterFactory.InlineSerializer<? extends E>> inlineType;

    public static <E, T extends SerializerType<E>> Builder<E, T> builder(ResourceKey<Registry<T>> registry, String elementName, String typeKey, Function<E, T> typeGetter) {
        return new Builder<E, T>(registry, elementName, typeKey, typeGetter);
    }

    protected ForgeRegistryObjectGSONAdapter(ResourceKey<Registry<T>> registryKey, String elementName, String typeKey, Function<E, T> typeGetter, Supplier<T> defaultType, Pair<Supplier<T>, GsonAdapterFactory.InlineSerializer<? extends E>> inlineType) {
        this.registryKey = registryKey;
        this.elementName = elementName;
        this.typeKey = typeKey;
        this.typeGetter = typeGetter;
        this.defaultType = defaultType;
        this.inlineType = inlineType;
    }

    public JsonElement serialize(E src, Type typeOfSrc, JsonSerializationContext context) {
        SerializerType t = (SerializerType)this.typeGetter.apply(src);
        if (this.inlineType != null && this.inlineType.getFirst().get() == t) {
            return this.inlineType.getSecond().m_142413_(src, context);
        }
        if (t == null) {
            throw new JsonSyntaxException("Unknown type: " + src);
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(this.typeKey, this.getRegistry().getKey((Object)t).toString());
        t.m_79331_().m_6170_(jsonobject, src, context);
        return jsonobject;
    }

    public E deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            SerializerType t;
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)this.elementName);
            String s = GsonHelper.m_13851_((JsonObject)jsonobject, (String)this.typeKey, (String)"");
            if (s.isEmpty()) {
                t = (SerializerType)this.defaultType.get();
            } else {
                ResourceLocation resourcelocation = new ResourceLocation(s);
                t = (SerializerType)this.getRegistry().getValue(resourcelocation);
            }
            if (t == null) {
                throw new JsonSyntaxException("Unknown type '" + s + "'");
            }
            return (E)t.m_79331_().m_7561_(jsonobject, context);
        }
        if (this.inlineType == null) {
            throw new UnsupportedOperationException("Object " + json + " can't be deserialized");
        }
        return (E)this.inlineType.getSecond().m_142268_(json, context);
    }

    private IForgeRegistry<T> getRegistry() {
        return PetrolparkRegistries.getRegistry(this.registryKey);
    }

    public static class Builder<E, T extends SerializerType<E>> {
        private final ResourceKey<Registry<T>> registry;
        private final String elementName;
        private final String typeKey;
        private final Function<E, T> typeGetter;
        @Nullable
        private Pair<Supplier<T>, GsonAdapterFactory.InlineSerializer<? extends E>> inlineType;
        @Nullable
        private Supplier<T> defaultType;

        Builder(ResourceKey<Registry<T>> registry, String elementName, String typeKey, Function<E, T> typeGetter) {
            this.registry = registry;
            this.elementName = elementName;
            this.typeKey = typeKey;
            this.typeGetter = typeGetter;
        }

        public Builder<E, T> withInlineSerializer(Supplier<T> inlineType, GsonAdapterFactory.InlineSerializer<? extends E> pInlineSerializer) {
            this.inlineType = Pair.of(inlineType, pInlineSerializer);
            return this;
        }

        public Builder<E, T> withDefaultType(Supplier<T> defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public ForgeRegistryObjectGSONAdapter<E, T> build() {
            return new ForgeRegistryObjectGSONAdapter<E, T>(this.registry, this.elementName, this.typeKey, this.typeGetter, this.defaultType, this.inlineType);
        }
    }
}

