/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item.nbt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mc.recraftors.blahaj.item.nbt.ContainedNbtElement;
import mc.recraftors.blahaj.item.nbt.ContainedNbtList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainedNbtCompound
extends CompoundTag
implements ContainedNbtElement<CompoundTag> {
    @NotNull
    private final CompoundTag containedCompound;
    @NotNull
    private final Set<Consumer<ContainedNbtElement<?>>> dirtyListeners;
    private boolean modified;
    private boolean busy;

    public ContainedNbtCompound(@NotNull CompoundTag containedNbtCompound, Consumer<ContainedNbtElement<?>> ... listeners) {
        this.containedCompound = containedNbtCompound;
        this.dirtyListeners = new HashSet();
        this.modified = false;
        this.busy = false;
        Arrays.stream(listeners).forEach(this.dirtyListeners::add);
    }

    @Override
    public final void dirty() {
        this.modified = true;
        if (this.busy) {
            return;
        }
        this.busy = true;
        this.dirtyListeners.forEach(listener -> listener.accept(this));
        this.busy = false;
    }

    @Override
    public void clean() {
        this.modified = false;
    }

    @Override
    public CompoundTag getContained() {
        return this.containedCompound;
    }

    @Override
    public boolean isDirty() {
        return this.modified;
    }

    @Override
    public Consumer<ContainedNbtElement<?>>[] getListeners() {
        return (Consumer[])this.dirtyListeners.toArray(Consumer[]::new);
    }

    public Set<String> m_128431_() {
        return this.containedCompound.m_128431_();
    }

    public int m_128440_() {
        return this.containedCompound.m_128440_();
    }

    @Nullable
    public Tag m_128365_(String string, Tag nbtElement) {
        Tag result = this.containedCompound.m_128365_(string, nbtElement);
        this.dirty();
        return result;
    }

    public void m_128344_(String string, byte b) {
        this.containedCompound.m_128344_(string, b);
        this.dirty();
    }

    public void m_128376_(String string, short s) {
        this.containedCompound.m_128376_(string, s);
        this.dirty();
    }

    public void m_128405_(String string, int i) {
        this.containedCompound.m_128405_(string, i);
        this.dirty();
    }

    public void m_128356_(String string, long l) {
        this.containedCompound.m_128356_(string, l);
        this.dirty();
    }

    public void m_128362_(String string, UUID uUID) {
        this.containedCompound.m_128362_(string, uUID);
        this.dirty();
    }

    public UUID m_128342_(String string) {
        return this.containedCompound.m_128342_(string);
    }

    public boolean m_128403_(String string) {
        return this.containedCompound.m_128403_(string);
    }

    public void m_128350_(String string, float f) {
        this.containedCompound.m_128350_(string, f);
        this.dirty();
    }

    public void m_128347_(String string, double d) {
        this.containedCompound.m_128347_(string, d);
        this.dirty();
    }

    public void m_128359_(String string, String string2) {
        this.containedCompound.m_128359_(string, string2);
        this.dirty();
    }

    public void m_128382_(String string, byte[] bs) {
        this.containedCompound.m_128382_(string, bs);
        this.dirty();
    }

    public void m_177853_(String string, List<Byte> list) {
        this.containedCompound.m_177853_(string, list);
        this.dirty();
    }

    public void m_128385_(String string, int[] is) {
        this.containedCompound.m_128385_(string, is);
        this.dirty();
    }

    public void m_128408_(String string, List<Integer> list) {
        this.containedCompound.m_128408_(string, list);
        this.dirty();
    }

    public void m_128388_(String string, long[] ls) {
        this.containedCompound.m_128388_(string, ls);
        this.dirty();
    }

    public void m_128428_(String string, List<Long> list) {
        this.containedCompound.m_128428_(string, list);
        this.dirty();
    }

    public void m_128379_(String string, boolean bl) {
        this.containedCompound.m_128379_(string, bl);
        this.dirty();
    }

    @Nullable
    public Tag m_128423_(String string) {
        return ContainedNbtElement.getContained(this.containedCompound.m_128423_(string), this.getListeners());
    }

    public byte m_128435_(String string) {
        return this.containedCompound.m_128435_(string);
    }

    public boolean m_128441_(String string) {
        return this.containedCompound.m_128441_(string);
    }

    public boolean m_128425_(String string, int i) {
        return this.containedCompound.m_128425_(string, i);
    }

    public byte m_128445_(String string) {
        return this.containedCompound.m_128445_(string);
    }

    public short m_128448_(String string) {
        return this.containedCompound.m_128448_(string);
    }

    public int m_128451_(String string) {
        return this.containedCompound.m_128451_(string);
    }

    public long m_128454_(String string) {
        return this.containedCompound.m_128454_(string);
    }

    public float m_128457_(String string) {
        return this.containedCompound.m_128457_(string);
    }

    public double m_128459_(String string) {
        return this.containedCompound.m_128459_(string);
    }

    public String m_128461_(String string) {
        return this.containedCompound.m_128461_(string);
    }

    public byte[] m_128463_(String string) {
        return this.containedCompound.m_128463_(string);
    }

    public int[] m_128465_(String string) {
        return this.containedCompound.m_128465_(string);
    }

    public long[] m_128467_(String string) {
        return this.containedCompound.m_128467_(string);
    }

    public CompoundTag m_128469_(String string) {
        return this.containedCompound.m_128469_(string);
    }

    public ListTag m_128437_(String string, int i) {
        return new ContainedNbtList(this.containedCompound.m_128437_(string, i), this.getListeners());
    }

    public boolean m_128471_(String string) {
        return this.containedCompound.m_128471_(string);
    }

    public void m_128473_(String string) {
        this.containedCompound.m_128473_(string);
        this.dirty();
    }

    public String toString() {
        return this.containedCompound.toString();
    }

    public boolean m_128456_() {
        return this.containedCompound.m_128456_();
    }

    public CompoundTag m_6426_() {
        return this.containedCompound.m_6426_();
    }

    public boolean equals(Object object) {
        return this.containedCompound.equals(object);
    }

    public int hashCode() {
        return this.containedCompound.hashCode();
    }

    public CompoundTag m_128391_(CompoundTag nbtCompound) {
        this.containedCompound.m_128391_(nbtCompound);
        this.dirty();
        return this;
    }

    public void m_197573_(StreamTagVisitor nbtScanner) {
        this.containedCompound.m_197573_(nbtScanner);
        this.dirty();
    }

    public StreamTagVisitor.ValueResult m_196533_(StreamTagVisitor nbtScanner) {
        return this.containedCompound.m_196533_(nbtScanner);
    }
}

