/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.cheese;

import com.pyzpre.createbitterballen.block.cheese.YoungCheeseBlock;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.pyzpre.createbitterballen.index.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaxedYoungCheeseBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final BooleanProperty WAXED = BooleanProperty.m_61465_((String)"waxed");
    private static final VoxelShape SHAPE = WaxedYoungCheeseBlock.makeShape();

    public WaxedYoungCheeseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Item usedItem = itemStack.m_41720_();
        if (!world.f_46443_) {
            if (usedItem instanceof AxeItem) {
                if (this.handleDewaxing(world, pos, state)) {
                    return InteractionResult.SUCCESS;
                }
            } else if ((itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "shears"))) || itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/knives")))) && this.handleShearing(world, pos, state)) {
                this.playShearingEffect(world, pos);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private boolean handleDewaxing(Level world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            BlockState youngCheeseState = (BlockState)((BlockState)((YoungCheeseBlock)((Object)BlockRegistry.YOUNG_CHEESE.get())).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(false));
            world.m_7731_(pos, youngCheeseState, 3);
            this.playWaxOffEffect(world, pos);
            return true;
        }
        return false;
    }

    private boolean handleShearing(Level world, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 1 || age == 2) {
            this.dropCheeseProducts(world, pos, age);
            world.m_7471_(pos, false);
            this.playShearingEffect(world, pos);
            return true;
        }
        return false;
    }

    private void playWaxOffEffect(Level world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void dropCheeseProducts(Level world, BlockPos pos, int age) {
        ItemStack dropItem = age == 1 ? new ItemStack(ItemRegistry.YOUNG_CHEESE_WEDGE) : new ItemStack(ItemRegistry.AGED_CHEESE_WEDGE);
        RandomSource random = world.f_46441_;
        for (int i = 0; i < 4; ++i) {
            double d0 = random.m_188501_() * 0.7f + 0.15f;
            double d1 = (double)(random.m_188501_() * 0.7f + 0.060000002f) + 0.6;
            double d2 = random.m_188501_() * 0.7f + 0.15f;
            ItemStack itemStackCopy = dropItem.m_41777_();
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemStackCopy);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
    }

    private void playShearingEffect(Level world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, WAXED});
    }
}

