/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.registry.renderers;

import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.client.core.registry.models.MicrophoneModel;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.blocks.MicrophoneBlock;
import com.codinglitch.simpleradio.core.registry.blocks.MicrophoneBlockEntity;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector3f;

public class MicrophoneRenderer
implements BlockEntityRenderer<MicrophoneBlockEntity> {
    private MicrophoneModel model;

    public MicrophoneRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new MicrophoneModel(context.m_173582_(MicrophoneModel.LAYER_LOCATION));
    }

    public void render(MicrophoneBlockEntity blockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        BlockState state = blockEntity.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof MicrophoneBlock) {
            MicrophoneBlock microphoneBlock = (MicrophoneBlock)block;
            if (blockEntity.id != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.5f, 1.5f, 0.5f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(microphoneBlock.getYRotationDegrees(state)));
                float targetTilt = blockEntity.tilt - 1.5f;
                blockEntity.currentTilt = Math.lerp((float)blockEntity.currentTilt, (float)targetTilt, (float)Math.min((float)(Minecraft.m_91087_().m_91297_() * 0.3f), (float)1.0f));
                this.model.plug.f_104207_ = !blockEntity.getWires().isEmpty();
                this.model.body.f_104203_ = blockEntity.currentTilt;
                RadioRouter router = ClientRadioManager.getRouter(blockEntity.id);
                if (router != null) {
                    float rotation = Math.toRadians((float)(SimpleRadioBlocks.MICROPHONE.getYRotationDegrees(state) - 90.0f));
                    float tilt = blockEntity.currentTilt - 0.5f;
                    Vector3f normal = new Vector3f(Math.cos((float)rotation), 0.0f, Math.sin((float)rotation));
                    router.connectionOffset = new Vec3((double)(normal.x * Math.cos((float)tilt) * 0.25f), (double)(Math.sin((float)tilt) * 0.25f), (double)(normal.z * Math.cos((float)tilt) * 0.25f));
                }
                VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(blockEntity.isListening() ? MicrophoneModel.ACTIVE_LOCATION : MicrophoneModel.TEXTURE_LOCATION));
                this.model.m_7695_(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
        }
    }
}

