/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio.effects;

import com.codinglitch.simpleradio.radio.effects.AudioEffect;
import java.util.Random;

public class BaseAudioEffect
extends AudioEffect {
    public static Random RANDOM = new Random();
    private float lastSample = 0.0f;

    @Override
    public short[] apply(short[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (!(RANDOM.nextFloat(100.0f) < this.severity)) continue;
            int n = i;
            data[n] = (short)(data[n] * 0);
        }
        this.bitCrush(data, 12 - Math.round(this.severity / 15.0f));
        this.downsample(data, 5 + Math.round(this.severity / 15.0f));
        this.lowPass(data);
        return super.apply(data);
    }

    public void lowPass(short[] data) {
        float alpha = 0.1f;
        for (int i = 0; i < data.length; ++i) {
            float filtered = alpha * (float)data[i] + (1.0f - alpha) * this.lastSample;
            data[i] = (short)filtered;
            this.lastSample = filtered;
        }
    }

    public void bitCrush(short[] data, int targetDepth) {
        int factor = 1 << 16 - targetDepth;
        for (int i = 0; i < data.length; ++i) {
            short sample = data[i];
            int quantized = (sample + factor / 2) / factor * factor;
            data[i] = (short)quantized;
        }
    }

    public void downsample(short[] data, int factor) {
        if (factor < 1) {
            return;
        }
        for (int i = 0; i < data.length; i += factor) {
            short sample = data[i];
            for (int j = i; j < i + factor && j < data.length; ++j) {
                data[j] = sample;
            }
        }
    }
}

