/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.xml.builders;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.queryparser.xml.DOMUtils;
import guideme.internal.shaded.lucene.queryparser.xml.ParserException;
import guideme.internal.shaded.lucene.queryparser.xml.QueryBuilder;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.TermQuery;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import org.w3c.dom.Element;

public class TermsQueryBuilder
implements QueryBuilder {
    private final Analyzer analyzer;

    public TermsQueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String text = DOMUtils.getNonBlankTextOrFail(e);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setMinimumNumberShouldMatch(DOMUtils.getAttribute(e, "minimumNumberShouldMatch", 0));
        try (TokenStream ts = this.analyzer.tokenStream(fieldName, text);){
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            Term term = null;
            ts.reset();
            while (ts.incrementToken()) {
                term = new Term(fieldName, BytesRef.deepCopyOf(termAtt.getBytesRef()));
                bq.add(new BooleanClause(new TermQuery(term), BooleanClause.Occur.SHOULD));
            }
            ts.end();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error constructing terms from index:" + ioe);
        }
        BooleanQuery q = bq.build();
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        return new BoostQuery(q, boost);
    }
}

