/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;

public abstract class ConstantScoreWeight
extends Weight {
    private final float score;

    protected ConstantScoreWeight(Query query, float score) {
        super(query);
        this.score = score;
    }

    protected final float score() {
        return this.score;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        boolean exists;
        Scorer s = this.scorer(context);
        if (s == null) {
            exists = false;
        } else {
            TwoPhaseIterator twoPhase = s.twoPhaseIterator();
            if (twoPhase == null) {
                exists = s.iterator().advance(doc) == doc;
            } else {
                boolean bl = exists = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
            }
        }
        if (exists) {
            return Explanation.match((Number)Float.valueOf(this.score), this.getQuery().toString() + (String)(this.score == 1.0f ? "" : "^" + this.score), new Explanation[0]);
        }
        return Explanation.noMatch(this.getQuery().toString() + " doesn't match id " + doc, new Explanation[0]);
    }
}

