/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GuiSpriteScaling {
    public static final Logger LOG = LoggerFactory.getLogger(GuiSpriteScaling.class);
    public static final MetadataSectionSerializer<GuiSpriteScaling> SERIALIZER = new MetadataSectionSerializer<GuiSpriteScaling>(){

        public String m_7991_() {
            return "gui";
        }

        public GuiSpriteScaling fromJson(JsonObject json) {
            return (GuiSpriteScaling)((Pair)Util.m_260975_((DataResult)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("scaling")), RuntimeException::new)).getFirst();
        }
    };
    public static final Codec<GuiSpriteScaling> CODEC = Type.CODEC.dispatch(GuiSpriteScaling::type, type -> type.codec().codec());
    public static final GuiSpriteScaling DEFAULT = new Stretch();

    public Type type();

    public static enum Type implements StringRepresentable
    {
        STRETCH("stretch", Stretch.CODEC),
        TILE("tile", Tile.CODEC),
        NINE_SLICE("nine_slice", NineSlice.CODEC);

        public static final Codec<Type> CODEC;
        private final String key;
        private final MapCodec<? extends GuiSpriteScaling> codec;

        private Type(String key, MapCodec<? extends GuiSpriteScaling> codec) {
            this.key = key;
            this.codec = codec;
        }

        public String m_7912_() {
            return this.key;
        }

        public MapCodec<? extends GuiSpriteScaling> codec() {
            return this.codec;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }

    public record Stretch() implements GuiSpriteScaling
    {
        public static final MapCodec<Stretch> CODEC = MapCodec.unit(Stretch::new);

        @Override
        public Type type() {
            return Type.STRETCH;
        }
    }

    public record Tile(int width, int height) implements GuiSpriteScaling
    {
        public static final MapCodec<Tile> CODEC = RecordCodecBuilder.mapCodec(p_294311_ -> p_294311_.group((App)ExtraCodecs.f_144629_.fieldOf("width").forGetter(Tile::width), (App)ExtraCodecs.f_144629_.fieldOf("height").forGetter(Tile::height)).apply((Applicative)p_294311_, Tile::new));

        @Override
        public Type type() {
            return Type.TILE;
        }
    }

    public record NineSlice(int width, int height, Border border) implements GuiSpriteScaling
    {
        public static final MapCodec<NineSlice> CODEC = RecordCodecBuilder.mapCodec(p_295296_ -> p_295296_.group((App)ExtraCodecs.f_144629_.fieldOf("width").forGetter(NineSlice::width), (App)ExtraCodecs.f_144629_.fieldOf("height").forGetter(NineSlice::height), (App)Border.CODEC.fieldOf("border").forGetter(NineSlice::border)).apply((Applicative)p_295296_, NineSlice::new)).flatXmap(NineSlice::validate, NineSlice::validate);

        private static DataResult<NineSlice> validate(NineSlice nineSlice) {
            Border guispritescaling$nineslice$border = nineSlice.border();
            if (guispritescaling$nineslice$border.left() + guispritescaling$nineslice$border.right() >= nineSlice.width()) {
                return DataResult.error(() -> "Nine-sliced texture has no horizontal center slice: " + guispritescaling$nineslice$border.left() + " + " + guispritescaling$nineslice$border.right() + " >= " + nineSlice.width());
            }
            return guispritescaling$nineslice$border.top() + guispritescaling$nineslice$border.bottom() >= nineSlice.height() ? DataResult.error(() -> "Nine-sliced texture has no vertical center slice: " + guispritescaling$nineslice$border.top() + " + " + guispritescaling$nineslice$border.bottom() + " >= " + nineSlice.height()) : DataResult.success((Object)nineSlice);
        }

        @Override
        public Type type() {
            return Type.NINE_SLICE;
        }

        public record Border(int left, int top, int right, int bottom) {
            private static final Codec<Border> VALUE_CODEC = ExtraCodecs.f_144629_.flatComapMap(p_295538_ -> new Border((int)p_295538_, (int)p_295538_, (int)p_295538_, (int)p_295538_), p_295407_ -> {
                OptionalInt optionalint = p_295407_.unpackValue();
                return optionalint.isPresent() ? DataResult.success((Object)optionalint.getAsInt()) : DataResult.error(() -> "Border has different side sizes");
            });
            private static final Codec<Border> RECORD_CODEC = RecordCodecBuilder.create(p_297930_ -> p_297930_.group((App)ExtraCodecs.f_144628_.fieldOf("left").forGetter(Border::left), (App)ExtraCodecs.f_144628_.fieldOf("top").forGetter(Border::top), (App)ExtraCodecs.f_144628_.fieldOf("right").forGetter(Border::right), (App)ExtraCodecs.f_144628_.fieldOf("bottom").forGetter(Border::bottom)).apply((Applicative)p_297930_, Border::new));
            static final Codec<Border> CODEC = Codec.either(VALUE_CODEC, RECORD_CODEC).xmap(e -> (Border)e.map(Function.identity(), Function.identity()), p_296295_ -> p_296295_.unpackValue().isPresent() ? Either.left((Object)p_296295_) : Either.right((Object)p_296295_));

            private OptionalInt unpackValue() {
                return this.left() == this.top() && this.top() == this.right() && this.right() == this.bottom() ? OptionalInt.of(this.left()) : OptionalInt.empty();
            }
        }
    }
}

