/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.respiteful.entries;

import com.tterrag.registrate.util.entry.RegistryEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import plus.dragons.respiteful.Respiteful;
import plus.dragons.respiteful.entries.builders.MobEffectBuilder;

public class RespitefulMobEffects {
    public static final RegistryEntry<MobEffect> VITALITY = Respiteful.REGISTRATE.mobEffect("vitality").description("Grants resistance for Wither effect and increases healing amount; higher levels grants stronger resistance and gives more additional healing amount.").category(MobEffectCategory.BENEFICIAL).color(5346881).register();
    public static final RegistryEntry<MobEffect> TENACITY = ((MobEffectBuilder)Respiteful.REGISTRATE.mobEffect("tenacity").description("Increases armor toughness and knockback resistance; higher levels gives more armor toughness and knockback resistance.").category(MobEffectCategory.BENEFICIAL).color(15518533).onRegister(effect -> effect.m_19472_(Attributes.f_22285_, "6624c857-48be-49ff-921b-15172d3c19c1", 2.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22278_, "d673225e-8a54-4362-987f-5e82f7ca99e3", 0.2, AttributeModifier.Operation.ADDITION))).register();
    public static final RegistryEntry<MobEffect> MATURITY = Respiteful.REGISTRATE.mobEffect("maturity").description("Grants immunity for harmful effects from food and increases food restore when eating; higher levels restores more food.").category(MobEffectCategory.BENEFICIAL).color(7880231).register();

    public static void register(IEventBus modBus) {
    }

    @Mod.EventBusSubscriber(modid="respiteful")
    public static class ForgeEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void increaseHealingAmount(LivingHealEvent event) {
            LivingEntity entity = event.getEntity();
            MobEffectInstance vitality = entity.m_21124_((MobEffect)VITALITY.get());
            if (vitality == null) {
                return;
            }
            float amount = event.getAmount();
            int amplifier = vitality.m_19564_();
            float increase = Math.min(amount, (float)(1L << amplifier));
            event.setAmount(amount + increase);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void witherResistance(MobEffectEvent.Applicable event) {
            MobEffectInstance wither = event.getEffectInstance();
            if (wither.m_19544_() != MobEffects.f_19615_) {
                return;
            }
            LivingEntity entity = event.getEntity();
            MobEffectInstance vitality = entity.m_21124_((MobEffect)VITALITY.get());
            if (vitality == null) {
                return;
            }
            if (wither.m_19564_() <= vitality.m_19564_()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

