/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import java.io.ByteArrayInputStream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.FriendlyByteBuf;

public class SyncConfigsMessage
implements Message {
    public final String fineName;
    public final String modId;
    public final byte[] configData;

    public SyncConfigsMessage(FriendlyByteBuf buf) {
        this.modId = buf.m_130277_();
        this.fineName = buf.m_130277_();
        this.configData = buf.m_130052_();
    }

    public SyncConfigsMessage(byte[] configFileData, String fileName, String modId) {
        this.modId = modId;
        this.fineName = fileName;
        this.configData = configFileData;
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.modId);
        buf.m_130070_(this.fineName);
        buf.m_130087_(this.configData);
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        if (PlatHelper.getCurrentServer() != null) {
            return;
        }
        ConfigSpec config = ConfigSpec.getSpec(this.modId, ConfigType.COMMON);
        if (config != null) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(this.configData);){
                config.loadFromBytes(stream);
                Moonlight.LOGGER.info("Synced {} configs", (Object)this.fineName);
            }
            catch (Exception exception) {}
        } else {
            Moonlight.LOGGER.error("Failed to find config file with name {}", (Object)this.fineName);
        }
    }
}

