/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.other;

import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBiomeTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanFeatures;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class NeapolitanBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        NeapolitanBiomeModifiers.addFeature(context, "strawberry_bush", NeapolitanBiomeTags.HAS_STRAWBERRY_BUSH, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_STRAWBERRY_BUSH);
        NeapolitanBiomeModifiers.addFeature(context, "adzuki_sprouts", NeapolitanBiomeTags.HAS_ADZUKI_SPROUTS, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_ADZUKI_SPROUTS);
        NeapolitanBiomeModifiers.addFeature(context, "vanilla_vine", NeapolitanBiomeTags.HAS_VANILLA_VINE, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_VANILLA_VINE);
        NeapolitanBiomeModifiers.addFeature(context, "mint_pond", NeapolitanBiomeTags.HAS_MINT_POND, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.MINT_POND);
        NeapolitanBiomeModifiers.addFeature(context, "banana_plant/common", NeapolitanBiomeTags.HAS_COMMON_BANANA_PLANT, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_COMMON);
        NeapolitanBiomeModifiers.addFeature(context, "banana_plant/uncommon", NeapolitanBiomeTags.HAS_UNCOMMON_BANANA_PLANT, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_UNCOMMON);
        NeapolitanBiomeModifiers.addFeature(context, "banana_plant/rare", NeapolitanBiomeTags.HAS_RARE_BANANA_PLANT, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_RARE);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        NeapolitanBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), NeapolitanBiomeModifiers.featureSet(context, features), step));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("neapolitan", name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

