/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.StatueEntityModel;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.GlobeBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.PedestalBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.StatueBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.HitResult;

public class StatueBlockTileRenderer
implements BlockEntityRenderer<StatueBlockTile> {
    protected final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private final StatueEntityModel model;
    private final BlockRenderDispatcher blockRenderer;
    private final EntityRenderDispatcher entityRenderer;
    private boolean slim = false;

    public StatueBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new StatueEntityModel(context);
        this.blockRenderer = Minecraft.m_91087_().m_91289_();
        this.entityRenderer = Minecraft.m_91087_().m_91290_();
    }

    protected boolean canRenderName(StatueBlockTile tile) {
        BlockPos hitPos;
        BlockPos pos;
        HitResult hit;
        if (Minecraft.m_91404_() && tile.getPlayerSkin() != null && (hit = Minecraft.m_91087_().f_91077_) != null && hit.m_6662_() == HitResult.Type.BLOCK && (pos = tile.m_58899_()).equals((Object)(hitPos = BlockPos.m_274446_((Position)hit.m_82450_())))) {
            double d0 = this.entityRenderer.m_114378_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            return d0 < 256.0;
        }
        return false;
    }

    public int m_142163_() {
        return 60;
    }

    public static ResourceLocation getPlayerSkin(GameProfile gameProfile) {
        return StatueBlockTileRenderer.getPlayerSkinAndSlim(gameProfile, s -> {});
    }

    public static ResourceLocation getPlayerSkinAndSlim(GameProfile gameProfile, Consumer<Boolean> slimSkinSetter) {
        if (!gameProfile.isComplete()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        SkinManager skinManager = Minecraft.m_91087_().m_91109_();
        Map skinCache = skinManager.m_118815_(gameProfile);
        if (skinCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture texture = (MinecraftProfileTexture)skinCache.get(MinecraftProfileTexture.Type.SKIN);
            String s = texture.getMetadata("model");
            boolean slim = s != null && !s.equals("default");
            slimSkinSetter.accept(slim);
            return skinManager.m_118825_(texture, MinecraftProfileTexture.Type.SKIN);
        }
        slimSkinSetter.accept(false);
        return DefaultPlayerSkin.m_118627_((UUID)gameProfile.getId());
    }

    private boolean isSkinSlim(GameProfile gameProfile) {
        return gameProfile != null && gameProfile.getId() != null && (gameProfile.getId().hashCode() & 1) == 1;
    }

    public void render(StatueBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        String name;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        GameProfile playerInfo = tile.getPlayerSkin();
        if (this.canRenderName(tile) && (name = playerInfo.getName()) != null) {
            PedestalBlockTileRenderer.renderName((Component)Component.m_237113_((String)name), 0.875f, poseStack, bufferIn, combinedLightIn);
        }
        ResourceLocation resourceLocation = playerInfo == null ? ModTextures.STATUE : StatueBlockTileRenderer.getPlayerSkinAndSlim(playerInfo, s -> {
            this.slim = s;
        });
        Direction dir = tile.getDirection();
        poseStack.m_252781_(RotHlpr.rot((Direction)dir));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, -0.25, 0.0);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)resourceLocation);
        StatueBlockTile.StatuePose pose = tile.getPose();
        ItemStack stack = tile.getDisplayedItem();
        if (MiscUtils.FESTIVITY.isHalloween()) {
            this.model.head.f_104207_ = false;
            this.model.hat.f_104207_ = false;
            if (pose == StatueBlockTile.StatuePose.STANDING) {
                pose = StatueBlockTile.StatuePose.HOLDING;
                stack = Items.f_42055_.m_7968_();
            } else {
                poseStack.m_85836_();
                poseStack.m_85841_(-0.625f, -0.625f, 0.625f);
                poseStack.m_85837_(0.0, 0.1875, 0.0);
                this.itemRenderer.m_269128_(Items.f_42047_.m_7968_(), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, tile.m_58904_(), 0);
                poseStack.m_85849_();
            }
        } else {
            this.model.head.f_104207_ = true;
            this.model.hat.f_104207_ = true;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.499f, 0.5f);
        VertexConsumer buffer = bufferIn.m_6299_(renderType);
        this.model.setupAnim(tile.m_58904_().m_46467_(), partialTicks, dir, pose, tile.isWaving(), this.slim);
        this.model.m_7695_(poseStack, buffer, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        this.slim = false;
        switch (pose) {
            case STANDING: {
                break;
            }
            case CANDLE: {
                poseStack.m_85841_(1.0f, -1.0f, -1.0f);
                poseStack.m_85837_(-0.5, -0.6875, -0.3125);
                this.blockRenderer.m_110912_(tile.hasCandle(), poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
                break;
            }
            default: {
                poseStack.m_85841_(-0.5f, -0.5f, 0.5f);
                BakedModel itemModel = this.itemRenderer.m_174264_(stack, tile.m_58904_(), null, 0);
                if (pose == StatueBlockTile.StatuePose.SWORD) {
                    poseStack.m_85837_(-0.35, -1.0625, 0.0);
                    poseStack.m_252781_(RotHlpr.Z135);
                } else if (pose == StatueBlockTile.StatuePose.TOOL) {
                    poseStack.m_85837_(-0.4, -1.25, 0.0);
                    poseStack.m_252781_(RotHlpr.Z135);
                }
                poseStack.m_85837_(0.0, -0.5, -0.5);
                if (pose.isGlobe()) {
                    if (GlobeBlockTileRenderer.INSTANCE == null) break;
                    boolean sepia = pose == StatueBlockTile.StatuePose.SEPIA_GLOBE;
                    Pair<GlobeManager.Model, ResourceLocation> pair = stack.m_41788_() ? GlobeManager.Type.getModelAndTexture(stack.m_41786_().getString()) : Pair.of((Object)((Object)GlobeManager.Model.GLOBE), null);
                    GlobeBlockTileRenderer.INSTANCE.renderGlobe(pair, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, sepia, tile.m_58904_());
                    break;
                }
                this.itemRenderer.m_115143_(stack, ItemDisplayContext.FIXED, true, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, itemModel);
            }
        }
        poseStack.m_85849_();
    }
}

