/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator.util;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ModelEndimatorCache<M> {
    private final Map<M, Endimator> endimatorMap = new WeakHashMap<M, Endimator>();
    private final Function<M, Endimator> factory;

    private ModelEndimatorCache(Function<M, Endimator> factory) {
        this.factory = factory;
    }

    public static <M> ModelEndimatorCache<M> forType(Function<M, Endimator> factory) {
        return new ModelEndimatorCache<M>(factory);
    }

    public Endimator getEndimator(M model) {
        return this.endimatorMap.computeIfAbsent(model, this.factory);
    }

    public void resetEndimator(M model, Endimator.ResetMode mode) {
        this.getEndimator(model).reset(mode);
    }

    public void endimate(M model, Endimator.ResetMode mode, Endimatable endimatable, float partialTicks) {
        Endimation endimation;
        PlayableEndimation playing = endimatable.getPlayingEndimation();
        if (playing != PlayableEndimation.BLANK && (endimation = playing.asEndimation()) != null) {
            float length;
            float time = ((float)endimatable.getAnimationTick() + partialTicks) * 0.05f;
            if (time > (length = endimation.getLength())) {
                time = length;
            }
            this.endimateModel(model, endimation, time, mode);
        }
    }

    public void endimateModel(M model, Endimation endimation, float time, Endimator.ResetMode mode) {
        this.getEndimator(model).apply(endimation, time, mode);
    }

    @SubscribeEvent
    public void onEntityRenderersReloaded(EntityRenderersEvent.AddLayers event) {
        this.endimatorMap.clear();
    }
}

