/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.core.advancement;

import com.petrolpark.compat.create.block.entity.behaviour.AbstractRememberPlacerBehaviour;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTrigger;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PetrolsPartsAdvancementBehaviour
extends AbstractRememberPlacerBehaviour {
    public static final BehaviourType<PetrolsPartsAdvancementBehaviour> TYPE = new BehaviourType();
    private final Set<PetrolsPartsAdvancementTrigger> advancements;

    public PetrolsPartsAdvancementBehaviour(SmartBlockEntity be, PetrolsPartsAdvancementTrigger ... advancements) {
        super(be);
        this.advancements = Set.of(advancements);
    }

    public void awardAdvancement(PetrolsPartsAdvancementTrigger advancement) {
        this.awardAdvancementIf(advancement, () -> true);
    }

    public void awardAdvancementIf(PetrolsPartsAdvancementTrigger advancement, Supplier<Boolean> condition) {
        ServerPlayer player;
        Player placer = this.getPlayer();
        if (placer == null || !(placer instanceof ServerPlayer) || advancement.isAlreadyAwardedTo((LivingEntity)(player = (ServerPlayer)placer))) {
            return;
        }
        if (condition.get().booleanValue()) {
            advancement.award(this.getWorld(), (Player)player);
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldRememberPlacer(Player placer) {
        if (!(placer instanceof ServerPlayer)) return false;
        ServerPlayer player = (ServerPlayer)placer;
        if (this.advancements.size() == 0) return true;
        if (this.advancements.stream().allMatch(advancement -> advancement.isAlreadyAwardedTo((LivingEntity)player))) return false;
        return true;
    }
}

