/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import xaero.hud.category.rule.ExcludeListMode;
import xaero.hud.category.serialization.data.FilterObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataNbtSerializer;

public class FilterObjectCategoryDataNbtSerializer<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataNbtSerializer<D, DB> {
    protected FilterObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        super(builderSupplier);
    }

    @Override
    public CompoundTag serialize(D data) {
        CompoundTag resultTag = super.serialize(data);
        resultTag.m_128359_("h", ((FilterObjectCategoryData)data).getHardInclude());
        resultTag.m_128379_("i", ((FilterObjectCategoryData)data).getIncludeListInSuperCategory());
        resultTag.m_128359_("m", ((FilterObjectCategoryData)data).getExcludeMode().name());
        ListTag includeListTag = new ListTag();
        ((FilterObjectCategoryData)data).getIncludeListIterator().forEachRemaining(includeEntry -> includeListTag.add((Object)StringTag.m_129297_((String)includeEntry)));
        resultTag.m_128365_("l", (Tag)includeListTag);
        ListTag excludeListTag = new ListTag();
        ((FilterObjectCategoryData)data).getExcludeListIterator().forEachRemaining(excludeEntry -> excludeListTag.add((Object)StringTag.m_129297_((String)excludeEntry)));
        resultTag.m_128365_("e", (Tag)excludeListTag);
        return resultTag;
    }

    @Override
    protected DB getConfiguredBuilder(CompoundTag serializedData) {
        FilterObjectCategoryData.Builder builder = (FilterObjectCategoryData.Builder)super.getConfiguredBuilder(serializedData);
        builder.setHardInclude(serializedData.m_128461_("h"));
        builder.setIncludeListInSuperCategory(serializedData.m_128471_("i"));
        builder.setExcludeMode(ExcludeListMode.valueOf(serializedData.m_128461_("m")));
        ListTag includeListTag = serializedData.m_128437_("l", 8);
        for (Tag includeEntryTag : includeListTag) {
            builder.addToIncludeList(includeEntryTag.m_7916_());
        }
        ListTag excludeListTag = serializedData.m_128437_("e", 8);
        for (Tag excludeEntryTag : excludeListTag) {
            builder.addToExcludeList(excludeEntryTag.m_7916_());
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected FilterObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new FilterObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>>
    extends ObjectCategoryDataNbtSerializer.Builder<D, DB, B> {
        protected Builder() {
        }

        @Override
        public FilterObjectCategoryDataNbtSerializer<D, DB> build() {
            return (FilterObjectCategoryDataNbtSerializer)super.build();
        }
    }
}

