/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.item.tabs;

import com.teamresourceful.resourcefullib.common.item.tabs.forge.ResourcefulCreativeTabImpl;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public class ResourcefulCreativeTab {
    public final ResourceLocation id;
    public Supplier<ItemStack> icon;
    public boolean hideScrollBar;
    public boolean hideTitle;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public final List<ResourcefulRegistry<ItemLike>> registries = new ArrayList<ResourcefulRegistry<ItemLike>>();
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public final List<Supplier<ItemStack>> stacks = new ArrayList<Supplier<ItemStack>>();
    public final List<Supplier<Stream<ItemStack>>> contents = new ArrayList<Supplier<Stream<ItemStack>>>();

    public ResourcefulCreativeTab(ResourceLocation id) {
        this.id = id;
    }

    public ResourcefulCreativeTab setItemIcon(Supplier<? extends ItemLike> icon) {
        return this.setStackIcon(() -> new ItemStack((ItemLike)icon.get()));
    }

    public ResourcefulCreativeTab setStackIcon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    public ResourcefulCreativeTab hideTitle() {
        this.hideTitle = true;
        return this;
    }

    public ResourcefulCreativeTab hideScrollBar() {
        this.hideScrollBar = true;
        return this;
    }

    public <I extends ItemLike, T extends ResourcefulRegistry<I>> ResourcefulCreativeTab addRegistry(T registry) {
        return this.addContent(() -> registry.boundStream().map(ItemStack::new));
    }

    public ResourcefulCreativeTab addStack(Supplier<ItemStack> stack) {
        return this.addContent(() -> Stream.of((ItemStack)stack.get()));
    }

    public ResourcefulCreativeTab addStack(ItemStack stack) {
        return this.addStack(() -> stack);
    }

    public ResourcefulCreativeTab addStack(ItemLike item) {
        return this.addStack(new ItemStack(item));
    }

    public ResourcefulCreativeTab addContent(Supplier<Stream<ItemStack>> content) {
        this.contents.add(content);
        return this;
    }

    public Supplier<CreativeModeTab> build() {
        return ResourcefulCreativeTab.create(this);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Supplier<CreativeModeTab> create(ResourcefulCreativeTab tab) {
        return ResourcefulCreativeTabImpl.create(tab);
    }
}

