/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterEntityType;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

public class EntityTypeModuleForge {
    public static final Map<AutoRegisterEntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> ENTITY_ATTRIBUTES = new HashMap<AutoRegisterEntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EntityTypeModuleForge::registerEntityTypes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EntityTypeModuleForge::registerEntityAttributes);
    }

    private static void registerEntityTypes(RegisterEvent event) {
        event.register(Registries.f_256939_, helper -> AutoRegistrationManager.ENTITY_TYPES.stream().filter(data -> !data.processed()).forEach(data -> EntityTypeModuleForge.registerEntityType(data, helper)));
    }

    private static void registerEntityType(AutoRegisterField data, RegisterEvent.RegisterHelper<EntityType<?>> helper) {
        AutoRegisterEntityType autoRegisterEntityType = (AutoRegisterEntityType)data.object();
        EntityType entityType = (EntityType)autoRegisterEntityType.get();
        helper.register(data.name(), (Object)entityType);
        if (autoRegisterEntityType.hasAttributes()) {
            ENTITY_ATTRIBUTES.put(autoRegisterEntityType, autoRegisterEntityType.getAttributesSupplier());
        }
        data.markProcessed();
    }

    private static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        ENTITY_ATTRIBUTES.forEach((entityType, builderSupplier) -> {
            AttributeSupplier.Builder builder = (AttributeSupplier.Builder)builderSupplier.get();
            builder.m_22266_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22266_((Attribute)ForgeMod.NAMETAG_DISTANCE.get()).m_22266_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            event.put((EntityType)entityType.get(), builder.m_22265_());
        });
    }
}

