/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config;

import com.goby56.wakes.config.enums.EffectSpawningRule;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.render.WakeColor;
import com.goby56.wakes.render.enums.RenderType;
import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;

public class WakesConfig
extends MidnightConfig {
    public static final String GENERAL = "general";
    public static final String APPEARANCE = "appearance";
    public static final String DEBUG = "debug";
    @MidnightConfig.Entry(category="general")
    public static boolean disableMod = false;
    @MidnightConfig.Entry(category="general")
    public static boolean pickBoat = true;
    @MidnightConfig.Comment(category="general", centered=true)
    public static MidnightConfig.Comment spawningRuleDivider;
    @MidnightConfig.Entry(category="general")
    public static EffectSpawningRule boatSpawning;
    @MidnightConfig.Entry(category="general")
    public static EffectSpawningRule playerSpawning;
    @MidnightConfig.Entry(category="general")
    public static EffectSpawningRule otherPlayersSpawning;
    @MidnightConfig.Entry(category="general")
    public static EffectSpawningRule mobSpawning;
    @MidnightConfig.Entry(category="general")
    public static EffectSpawningRule itemSpawning;
    @MidnightConfig.Comment(category="general", centered=true)
    public static MidnightConfig.Comment wakeBehaviourDivider;
    @MidnightConfig.Entry(category="general")
    public static float wavePropagationFactor;
    @MidnightConfig.Entry(category="general")
    public static float waveDecayFactor;
    @MidnightConfig.Entry(category="general")
    public static int initialStrength;
    @MidnightConfig.Entry(category="general")
    public static int paddleStrength;
    @MidnightConfig.Entry(category="general")
    public static int splashStrength;
    @MidnightConfig.Entry(category="appearance")
    public static Resolution wakeResolution;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=0.0, max=1.0)
    public static float wakeOpacity;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=0.0, max=1.0)
    public static float blendStrength;
    @MidnightConfig.Entry(category="appearance")
    public static boolean firstPersonSplashPlane;
    @MidnightConfig.Entry(category="appearance")
    public static boolean spawnParticles;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=0.0, max=1.0)
    public static float shaderLightPassthrough;
    @MidnightConfig.Comment(category="appearance", centered=true)
    public static MidnightConfig.Comment splashPlaneDivider;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float splashPlaneWidth;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float splashPlaneHeight;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float splashPlaneDepth;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float splashPlaneOffset;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float splashPlaneGap;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static int splashPlaneResolution;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float maxSplashPlaneVelocity;
    @MidnightConfig.Entry(category="appearance", isSlider=true, min=-5.0, max=5.0)
    public static float splashPlaneScale;
    @MidnightConfig.Hidden
    @MidnightConfig.Entry(category="appearance")
    public static List<Float> wakeColorIntervals;
    @MidnightConfig.Hidden
    @MidnightConfig.Entry(category="appearance", isColor=true)
    public static List<String> wakeColors;
    public static List<Float> defaultWakeColorIntervals;
    public static List<String> defaultWakeColors;
    @MidnightConfig.Entry(category="debug")
    public static boolean debugColors;
    @MidnightConfig.Entry(category="debug")
    public static boolean drawDebugBoxes;
    @MidnightConfig.Entry(category="debug")
    public static boolean showDebugInfo;
    @MidnightConfig.Entry(category="debug", isSlider=true, min=1.0, max=6.0)
    public static int floodFillDistance;
    @MidnightConfig.Entry(category="debug", isSlider=true, min=1.0, max=20.0)
    public static int floodFillTickDelay;
    @MidnightConfig.Entry(category="debug")
    public static RenderType renderType;

    public static WakeColor getWakeColor(int i) {
        return new WakeColor(wakeColors.get(i));
    }

    static {
        boatSpawning = EffectSpawningRule.SIMULATION_AND_PLANES;
        playerSpawning = EffectSpawningRule.ONLY_SIMULATION;
        otherPlayersSpawning = EffectSpawningRule.ONLY_SIMULATION;
        mobSpawning = EffectSpawningRule.ONLY_SIMULATION;
        itemSpawning = EffectSpawningRule.ONLY_SIMULATION;
        wavePropagationFactor = 0.95f;
        waveDecayFactor = 0.5f;
        initialStrength = 20;
        paddleStrength = 100;
        splashStrength = 100;
        wakeResolution = Resolution.SIXTEEN;
        wakeOpacity = 1.0f;
        blendStrength = 0.5f;
        firstPersonSplashPlane = false;
        spawnParticles = true;
        shaderLightPassthrough = 0.5f;
        splashPlaneWidth = 2.0f;
        splashPlaneHeight = 1.5f;
        splashPlaneDepth = 3.0f;
        splashPlaneOffset = 0.0f;
        splashPlaneGap = 1.0f;
        splashPlaneResolution = 5;
        maxSplashPlaneVelocity = 0.5f;
        splashPlaneScale = 0.8f;
        wakeColorIntervals = Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.05f), Float.valueOf(0.15f), Float.valueOf(0.2f), Float.valueOf(0.35f), Float.valueOf(0.52f), Float.valueOf(0.6f), Float.valueOf(0.7f), Float.valueOf(0.9f)});
        wakeColors = Lists.newArrayList((Object[])new String[]{"#00000000", "#289399a6", "#649ea5b0", "#b4c4cad1", "#00000000", "#b4c4cad1", "#ffffffff", "#b4c4cad1", "#649ea5b0"});
        defaultWakeColorIntervals = Lists.newArrayList(wakeColorIntervals);
        defaultWakeColors = Lists.newArrayList(wakeColors);
        debugColors = false;
        drawDebugBoxes = false;
        showDebugInfo = false;
        floodFillDistance = 2;
        floodFillTickDelay = 2;
        renderType = RenderType.AUTO;
    }
}

