/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.GrowthAcceleratorBlockEntity;
import appeng.client.render.effects.ParticleTypes;
import appeng.core.AEConfig;
import appeng.core.AppEngClient;
import appeng.util.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrowthAcceleratorBlock
extends AEBaseEntityBlock<GrowthAcceleratorBlockEntity> {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");

    public GrowthAcceleratorBlock() {
        super(GrowthAcceleratorBlock.metalProps());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, GrowthAcceleratorBlockEntity be) {
        return (BlockState)currentState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(be.isPowered()));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.facing();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource r) {
        if (!AEConfig.instance().isEnableEffects()) {
            return;
        }
        GrowthAcceleratorBlockEntity cga = (GrowthAcceleratorBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cga != null && cga.isPowered() && AppEngClient.instance().shouldAddParticles(r)) {
            double d0 = r.m_188501_() - 0.5f;
            double d1 = r.m_188501_() - 0.5f;
            Direction up = cga.getTop();
            Direction forward = cga.getFront();
            Direction west = Platform.crossProduct(forward, up);
            double rx = 0.5 + (double)pos.m_123341_();
            double ry = 0.5 + (double)pos.m_123342_();
            double rz = 0.5 + (double)pos.m_123343_();
            rx += (double)up.m_122429_() * d0;
            ry += (double)up.m_122430_() * d0;
            rz += (double)up.m_122431_() * d0;
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            double dz = 0.0;
            double dx = 0.0;
            BlockPos pt = null;
            switch (r.m_188503_(4)) {
                case 0: {
                    dx = 0.6;
                    dz = d1;
                    pt = new BlockPos(x + west.m_122429_(), y + west.m_122430_(), z + west.m_122431_());
                    break;
                }
                case 1: {
                    dx = d1;
                    dz += 0.6;
                    pt = new BlockPos(x + forward.m_122429_(), y + forward.m_122430_(), z + forward.m_122431_());
                    break;
                }
                case 2: {
                    dx = d1;
                    dz = -0.6;
                    pt = new BlockPos(x - forward.m_122429_(), y - forward.m_122430_(), z - forward.m_122431_());
                    break;
                }
                case 3: {
                    dx = -0.6;
                    dz = d1;
                    pt = new BlockPos(x - west.m_122429_(), y - west.m_122430_(), z - west.m_122431_());
                }
            }
            if (!level.m_8055_(pt).m_60795_()) {
                return;
            }
            rx += dx * (double)west.m_122429_();
            ry += dx * (double)west.m_122430_();
            rz += dx * (double)west.m_122431_();
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.LIGHTNING, rx += dz * (double)forward.m_122429_(), ry += dz * (double)forward.m_122430_(), rz += dz * (double)forward.m_122431_(), 0.0, 0.0, 0.0);
        }
    }
}

