/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.service;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.events.statistics.GridChunkEvent;
import appeng.me.InWorldGridNode;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class StatisticsService
implements IGridService,
IGridServiceProvider {
    private final IGrid grid;
    private final Map<LevelAccessor, Multiset<ChunkPos>> chunks;

    public StatisticsService(IGrid g) {
        this.grid = g;
        this.chunks = new HashMap<LevelAccessor, Multiset<ChunkPos>>();
    }

    @Override
    public void removeNode(IGridNode node) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode inWorldNode = (InWorldGridNode)node;
            this.removeChunk((LevelAccessor)inWorldNode.getLevel(), inWorldNode.getLocation());
        }
    }

    @Override
    public void addNode(IGridNode node, @Nullable CompoundTag savedData) {
        if (node instanceof InWorldGridNode) {
            InWorldGridNode inWorldNode = (InWorldGridNode)node;
            this.addChunk((LevelAccessor)inWorldNode.getLevel(), inWorldNode.getLocation());
        }
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public Set<LevelAccessor> getLevels() {
        return this.chunks.keySet();
    }

    public Set<ChunkPos> chunks(LevelAccessor level) {
        return this.chunks.get(level).elementSet();
    }

    public Map<LevelAccessor, Multiset<ChunkPos>> getChunks() {
        return this.chunks;
    }

    private boolean addChunk(LevelAccessor level, BlockPos pos) {
        ChunkPos position = new ChunkPos(pos);
        if (!this.getChunks(level).contains((Object)position)) {
            this.grid.postEvent(new GridChunkEvent.GridChunkAdded((ServerLevel)level, position));
        }
        return this.getChunks(level).add((Object)position);
    }

    private boolean removeChunk(LevelAccessor level, BlockPos pos) {
        ChunkPos position = new ChunkPos(pos);
        boolean ret = this.getChunks(level).remove((Object)position);
        if (ret && !this.getChunks(level).contains((Object)position)) {
            this.grid.postEvent(new GridChunkEvent.GridChunkRemoved((ServerLevel)level, position));
        }
        this.clearLevel(level);
        return ret;
    }

    private Multiset<ChunkPos> getChunks(LevelAccessor level) {
        return this.chunks.computeIfAbsent(level, l -> HashMultiset.create());
    }

    private void clearLevel(LevelAccessor level) {
        if (this.chunks.get(level).isEmpty()) {
            this.chunks.remove(level);
        }
    }
}

