/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.slot.AppEngCraftingSlot;
import appeng.util.Platform;
import appeng.util.inv.CarriedItemInventory;
import appeng.util.inv.PlayerInternalInventory;
import appeng.util.prioritylist.IPartitionList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingTermSlot
extends AppEngCraftingSlot {
    private final InternalInventory craftInv;
    private final InternalInventory pattern;
    private final IActionSource mySrc;
    private final IEnergySource energySrc;
    private final MEStorage storage;
    private final IMenuCraftingPacket menu;

    public CraftingTermSlot(Player player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, IMenuCraftingPacket ccp) {
        super(player, cMatrix);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.menu = ccp;
    }

    @Override
    public boolean m_8010_(Player player) {
        return false;
    }

    @Override
    public void m_142406_(Player p, ItemStack is) {
    }

    public void doClick(InventoryAction action, Player who) {
        int maxTimesToCraft;
        InternalInventory target;
        if (this.m_7993_().m_41619_()) {
            return;
        }
        if (this.isRemote()) {
            return;
        }
        int howManyPerCraft = this.m_7993_().m_41613_();
        if (action == InventoryAction.CRAFT_SHIFT || action == InventoryAction.CRAFT_ALL) {
            target = new PlayerInternalInventory(who.m_150109_());
            maxTimesToCraft = action == InventoryAction.CRAFT_SHIFT ? (int)Math.floor((double)this.m_7993_().m_41741_() / (double)howManyPerCraft) : (int)Math.floor((double)this.m_7993_().m_41741_() / (double)howManyPerCraft * 36.0);
        } else if (action == InventoryAction.CRAFT_STACK) {
            target = new CarriedItemInventory(this.getMenu());
            maxTimesToCraft = (int)Math.floor((double)this.m_7993_().m_41741_() / (double)howManyPerCraft);
        } else {
            if (this.getMenu().m_142621_().m_41619_()) {
                this.getMenu().m_142503_(this.craftItem(who, this.storage, this.storage.getAvailableStacks()));
                return;
            }
            target = new CarriedItemInventory(this.getMenu());
            maxTimesToCraft = 1;
        }
        ItemStack itemAtStart = this.m_7993_().m_41777_();
        if (itemAtStart.m_41619_()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            if (!ItemStack.m_150942_((ItemStack)itemAtStart, (ItemStack)this.m_7993_())) {
                return;
            }
            if (!target.simulateAdd(itemAtStart).m_41619_()) {
                return;
            }
            KeyCounter all = this.storage.getAvailableStacks();
            ItemStack extra = target.addItems(this.craftItem(who, this.storage, all));
            if (extra.m_41619_()) continue;
            Platform.spawnDrops(who.m_9236_(), who.m_20183_(), List.of(extra));
            return;
        }
    }

    protected Recipe<CraftingContainer> findRecipe(CraftingContainer ic, Level level) {
        CraftingTermMenu terminalMenu;
        Recipe<CraftingContainer> recipe;
        IMenuCraftingPacket iMenuCraftingPacket = this.menu;
        if (iMenuCraftingPacket instanceof CraftingTermMenu && (recipe = (terminalMenu = (CraftingTermMenu)iMenuCraftingPacket).getCurrentRecipe()) != null && recipe.m_5818_((Container)ic, level)) {
            return terminalMenu.getCurrentRecipe();
        }
        return level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)ic, level).orElse(null);
    }

    @Override
    protected NonNullList<ItemStack> getRemainingItems(CraftingContainer ic, Level level) {
        CraftingTermMenu terminalMenu;
        Recipe<CraftingContainer> recipe;
        IMenuCraftingPacket iMenuCraftingPacket = this.menu;
        if (iMenuCraftingPacket instanceof CraftingTermMenu && (recipe = (terminalMenu = (CraftingTermMenu)iMenuCraftingPacket).getCurrentRecipe()) != null && recipe.m_5818_((Container)ic, level)) {
            return terminalMenu.getCurrentRecipe().m_7457_((Container)ic);
        }
        return super.getRemainingItems(ic, level);
    }

    private ItemStack craftItem(Player p, MEStorage inv, KeyCounter all) {
        ItemStack is = this.m_7993_().m_41777_();
        if (is.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Object[] set = new ItemStack[this.getPattern().size()];
        Arrays.fill(set, ItemStack.f_41583_);
        Level level = p.m_9236_();
        if (!level.m_5776_()) {
            TransientCraftingContainer ic = new TransientCraftingContainer(p.f_36096_, 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.m_6836_(x, this.getPattern().getStackInSlot(x));
            }
            Recipe<CraftingContainer> r = this.findRecipe((CraftingContainer)ic, level);
            if (r == null) {
                Item target = is.m_41720_();
                if (target.m_41465_() && target.m_6832_(is, is)) {
                    boolean isBad = false;
                    for (int x = 0; x < ic.m_6643_(); ++x) {
                        ItemStack pis = ic.m_8020_(x);
                        if (pis.m_41619_() || pis.m_41720_() == target) continue;
                        isBad = true;
                    }
                    if (!isBad) {
                        super.m_142406_(p, is);
                        p.f_36096_.m_6199_(this.craftInv.toContainer());
                        return is;
                    }
                }
                return ItemStack.f_41583_;
            }
            is = r.m_5874_((Container)ic, level.m_9598_());
            if (inv != null) {
                IPartitionList filter = ViewCellItem.createItemFilter(this.menu.getViewCells());
                for (int x = 0; x < this.getPattern().size(); ++x) {
                    if (this.getPattern().getStackInSlot(x).m_41619_()) continue;
                    set[x] = Platform.extractItemsByRecipe(this.energySrc, this.mySrc, inv, level, r, is, (CraftingContainer)ic, this.getPattern().getStackInSlot(x), x, all, Actionable.MODULATE, filter);
                    ic.m_6836_(x, (ItemStack)set[x]);
                }
            }
        }
        if (this.preCraft(p, inv, (ItemStack[])set, is)) {
            this.makeItem(p, is);
            this.postCraft(p, inv, (ItemStack[])set, is);
        }
        p.f_36096_.m_6199_(this.craftInv.toContainer());
        return is;
    }

    private boolean preCraft(Player p, MEStorage inv, ItemStack[] set, ItemStack result) {
        return true;
    }

    private void makeItem(Player p, ItemStack is) {
        super.m_142406_(p, is);
    }

    private void postCraft(Player p, MEStorage inv, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!p.m_20193_().m_5776_()) {
            for (int x = 0; x < this.craftInv.size(); ++x) {
                int amount;
                AEItemKey what;
                long inserted;
                if (this.craftInv.getStackInSlot(x).m_41619_()) {
                    this.craftInv.setItemDirect(x, set[x]);
                    continue;
                }
                if (set[x].m_41619_() || (inserted = inv.insert(what = AEItemKey.of(set[x]), amount = set[x].m_41613_(), Actionable.MODULATE, this.mySrc)) >= (long)amount) continue;
                drops.add(what.toStack((int)((long)amount - inserted)));
            }
        }
        if (drops.size() > 0) {
            Platform.spawnDrops(p.m_9236_(), new BlockPos((int)p.m_20185_(), (int)p.m_20186_(), (int)p.m_20189_()), drops);
        }
    }

    InternalInventory getPattern() {
        return this.pattern;
    }
}

