/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.entity.animal;

import com.google.common.collect.Lists;
import com.teamabnormals.caverns_and_chasms.common.block.CopperButtonBlock;
import com.teamabnormals.caverns_and_chasms.common.entity.ControllableGolem;
import com.teamabnormals.caverns_and_chasms.common.entity.ai.goal.FollowTuningForkGoal;
import com.teamabnormals.caverns_and_chasms.common.entity.decoration.OxidizedCopperGolem;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBlockTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CopperGolem
extends AbstractGolem
implements ControllableGolem {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("A8EF581F-B1E8-4950-860C-06FA72505003");
    private static final EntityDataAccessor<Integer> OXIDATION = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WAXED = SynchedEntityData.m_135353_(CopperGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oxidationTime = this.nextOxidationTime();
    private int ticksSinceButtonPress;
    private int headSpinTicks;
    private int headSpinTicksO;
    private int buttonPressTicks;
    private int buttonPressTicksO;

    public CopperGolem(EntityType<? extends CopperGolem> entity, Level level) {
        super(entity, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FollowTuningForkGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PressButtonGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomWalkingGoal());
        this.f_21345_.m_25352_(3, (Goal)new StareAtPlayerGoal());
        this.f_21345_.m_25352_(4, (Goal)new LookAroundRandomly());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OXIDATION, (Object)0);
        this.f_19804_.m_135372_(WAXED, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.25);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_STEP.get(), 1.0f, 1.0f);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Oxidation", this.getOxidation().getId());
        compound.m_128405_("OxidationTime", this.oxidationTime);
        compound.m_128379_("Waxed", this.isWaxed());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setOxidation(Oxidation.byId(compound.m_128451_("Oxidation")));
        if (compound.m_128441_("OxidationTime")) {
            this.oxidationTime = compound.m_128451_("OxidationTime");
        }
        this.setWaxed(compound.m_128471_("Waxed"));
    }

    public Oxidation getOxidation() {
        return Oxidation.byId((Integer)this.f_19804_.m_135370_(OXIDATION));
    }

    public void setOxidation(Oxidation oxidation) {
        this.f_19804_.m_135381_(OXIDATION, (Object)oxidation.getId());
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        attributeinstance.m_22120_(SPEED_MODIFIER_UUID);
        if (oxidation != Oxidation.UNAFFECTED) {
            double penalty = oxidation == Oxidation.EXPOSED ? -0.075 : (oxidation == Oxidation.WEATHERED ? -0.15 : -0.25);
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Weathering speed penalty", penalty, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(WAXED, (Object)waxed);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.isWaxed() && --this.oxidationTime <= 0) {
            Oxidation oxidation = this.getOxidation();
            if (oxidation != Oxidation.WEATHERED) {
                this.setOxidation(Oxidation.byId(oxidation.getId() + 1));
                this.oxidationTime = this.nextOxidationTime();
            } else {
                this.oxidizeIntoStatue();
            }
        }
        this.updateHeadSpinTicks();
        this.updateButtonPressTicks();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.isWaxed() && this.f_19797_ % 40 == 0) {
                double d0 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                double d1 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                double d2 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20208_(0.8), this.m_20227_(0.1), this.m_20262_(0.8), d0, d1, d2);
            }
        } else if (this.ticksSinceButtonPress > 0) {
            --this.ticksSinceButtonPress;
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        boolean success = false;
        if (item == Items.f_151052_) {
            float f = this.m_21223_();
            this.m_5634_(15.0f);
            if (this.m_21223_() != f) {
                this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_REPAIR.get(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                success = true;
            }
        } else if (item == Items.f_42784_) {
            if (!this.isWaxed()) {
                this.setWaxed(true);
                this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175828_);
                this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144178_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                success = true;
            }
        } else if (item instanceof AxeItem) {
            if (this.isWaxed()) {
                this.setWaxed(false);
                this.oxidationTime = this.nextOxidationTime();
                this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175829_);
                this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144060_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                success = true;
            } else if (this.getOxidation().getId() > 0) {
                this.setOxidation(Oxidation.byId(this.getOxidation().getId() - 1));
                this.oxidationTime = this.nextOxidationTime();
                this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175831_);
                this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144059_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                success = true;
            }
            if (success && !this.m_9236_().f_46443_) {
                itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            }
        }
        return success ? InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_) : InteractionResult.PASS;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
        if (this.getOxidation() != Oxidation.UNAFFECTED) {
            this.setOxidation(Oxidation.UNAFFECTED);
        }
        this.spinHead();
        this.m_9236_().m_7605_((Entity)this, (byte)5);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean damaged = this.isDamaged();
        boolean flag = super.m_6469_(source, amount);
        if (flag) {
            this.spinHead();
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            if (this.isDamaged() != damaged) {
                this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_DAMAGE.get(), 1.0f, 1.0f);
            }
        }
        return flag;
    }

    private void oxidizeIntoStatue() {
        OxidizedCopperGolem oxidizedgolem = (OxidizedCopperGolem)((EntityType)CCEntityTypes.OXIDIZED_COPPER_GOLEM.get()).m_20615_(this.m_9236_());
        float yRot = (float)Mth.m_14143_((float)((this.m_146908_() + 22.5f) / 45.0f)) * 45.0f;
        oxidizedgolem.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), yRot, 0.0f);
        oxidizedgolem.m_5616_(yRot);
        oxidizedgolem.setNoAi(this.m_21525_());
        oxidizedgolem.m_20225_(this.m_20067_());
        oxidizedgolem.m_20242_(this.m_20068_());
        oxidizedgolem.m_146915_(this.m_146886_());
        oxidizedgolem.m_20331_(this.m_20147_());
        oxidizedgolem.setPersistenceRequired(this.m_21532_());
        oxidizedgolem.setDamaged(this.isDamaged());
        if (this.m_8077_()) {
            oxidizedgolem.m_6593_(this.m_7770_());
            oxidizedgolem.m_20340_(this.m_20151_());
        }
        this.m_9236_().m_7967_((Entity)oxidizedgolem);
        this.m_146870_();
    }

    public boolean isDamaged() {
        return this.m_21223_() / this.m_21233_() < 0.5f;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.8f;
    }

    protected int m_7302_(int supply) {
        return supply;
    }

    @Override
    public void onTuningForkControlStart(Player controller) {
        this.spinHead();
    }

    @Override
    public void onTuningForkControlEnd(Player controller) {
        this.spinHead();
    }

    private int nextOxidationTime() {
        return this.f_19796_.m_188503_(144000) + 240000;
    }

    public void spinHead() {
        if (this.headSpinTicks <= 10) {
            this.headSpinTicksO = this.headSpinTicks = 24;
            this.m_5496_((SoundEvent)CCSoundEvents.ENTITY_COPPER_GOLEM_GEAR.get(), 1.0f, 1.0f);
        }
    }

    private void pressButton() {
        this.buttonPressTicksO = this.buttonPressTicks = 12;
    }

    private void updateHeadSpinTicks() {
        this.headSpinTicksO = this.headSpinTicks;
        if (this.headSpinTicks > 0) {
            --this.headSpinTicks;
        }
    }

    private void updateButtonPressTicks() {
        this.buttonPressTicksO = this.buttonPressTicks;
        if (this.buttonPressTicks > 0) {
            --this.buttonPressTicks;
        }
    }

    public boolean isSpinningHead() {
        return this.headSpinTicks > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadSpinTicks(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.headSpinTicksO, (float)this.headSpinTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getPressButtonTicks(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.buttonPressTicksO, (float)this.buttonPressTicks);
    }

    private void spawnSparkParticles(ParticleOptions particle) {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 7; ++i) {
                double d0 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                double d1 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                double d2 = Mth.m_216263_((RandomSource)this.m_217043_(), (double)-1.0, (double)1.0);
                this.m_9236_().m_7106_(particle, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.spinHead();
        } else if (id == 5) {
            this.spinHead();
            this.spawnSparkParticles((ParticleOptions)ParticleTypes.f_175830_);
        } else if (id == 6) {
            this.pressButton();
        }
        super.m_7822_(id);
    }

    public static void createGolem(Level level, BlockPos pos, BlockState state) {
        Object golem;
        float yRot = ((Direction)state.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_();
        BlockPos abovepos = pos.m_7494_();
        BlockState abovestate = level.m_8055_(abovepos);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        level.m_7731_(abovepos, Blocks.f_50016_.m_49966_(), 2);
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        level.m_46796_(2001, abovepos, Block.m_49956_((BlockState)abovestate));
        if (abovestate.m_60713_((Block)CCBlocks.OXIDIZED_LIGHTNING_ROD.get()) || abovestate.m_60713_((Block)CCBlocks.WAXED_OXIDIZED_LIGHTNING_ROD.get())) {
            yRot = (float)Mth.m_14143_((float)((yRot + 22.5f) / 45.0f)) * 45.0f;
            golem = (LivingEntity)((EntityType)CCEntityTypes.OXIDIZED_COPPER_GOLEM.get()).m_20615_(level);
        } else {
            CopperGolem coppergolem = (CopperGolem)((EntityType)CCEntityTypes.COPPER_GOLEM.get()).m_20615_(level);
            coppergolem.setOxidation(abovestate.m_60713_(Blocks.f_152587_) || abovestate.m_60713_((Block)CCBlocks.WAXED_LIGHTNING_ROD.get()) ? Oxidation.UNAFFECTED : (abovestate.m_60713_((Block)CCBlocks.EXPOSED_LIGHTNING_ROD.get()) || abovestate.m_60713_((Block)CCBlocks.WAXED_EXPOSED_LIGHTNING_ROD.get()) ? Oxidation.EXPOSED : Oxidation.WEATHERED));
            if (abovestate.m_204336_(CCBlockTags.WAXED_COPPER_BLOCKS)) {
                coppergolem.setWaxed(true);
            }
            golem = coppergolem;
        }
        golem.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.5, yRot, 0.0f);
        golem.m_5616_(yRot);
        golem.m_5618_(yRot);
        level.m_7967_((Entity)golem);
        for (ServerPlayer serverplayer : level.m_45976_(ServerPlayer.class, golem.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)golem);
        }
        level.m_6289_(pos, Blocks.f_50016_);
        level.m_6289_(abovepos, Blocks.f_50016_);
    }

    class PressButtonGoal
    extends Goal {
        private BlockPos blockPos = BlockPos.f_121853_;
        private Vec3i buttonNormal;
        private int nextStartTicks;
        private int tryTicks;
        private int maxStayTicks;
        private int pressWaitTicks;

        public PressButtonGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.nextStartTicks > 0) {
                --this.nextStartTicks;
                return false;
            }
            this.nextStartTicks = 20;
            return !CopperGolem.this.isBeingTuningForkControlled() && this.findRandomButton();
        }

        public boolean m_8045_() {
            if (CopperGolem.this.isBeingTuningForkControlled()) {
                return false;
            }
            if (this.tryTicks < -this.maxStayTicks || this.tryTicks > 1200) {
                return false;
            }
            return this.isUnpressedButton((LevelReader)CopperGolem.this.m_9236_(), this.blockPos);
        }

        public void m_8056_() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            this.maxStayTicks = CopperGolem.this.m_217043_().m_188503_(CopperGolem.this.m_217043_().m_188503_(1200) + 1200) + 1200;
            this.pressWaitTicks = 16;
        }

        public void m_8037_() {
            CopperGolem.this.m_21563_().m_24950_((double)this.blockPos.m_123341_() + 0.5 + (double)this.buttonNormal.m_123341_() * 0.5, (double)this.blockPos.m_123342_() + 0.5 + (double)this.buttonNormal.m_123342_() * 0.5, (double)this.blockPos.m_123343_() + 0.5 + (double)this.buttonNormal.m_123343_() * 0.5, 10.0f, (float)CopperGolem.this.m_8132_());
            if (CopperGolem.this.m_20275_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5) > 1.5625) {
                ++this.tryTicks;
                this.pressWaitTicks = 20;
                if (this.tryTicks % 40 == 0) {
                    this.moveMobToBlock();
                }
            } else {
                BlockState state;
                --this.tryTicks;
                --this.pressWaitTicks;
                if (this.pressWaitTicks == 6) {
                    CopperGolem.this.pressButton();
                    CopperGolem.this.m_9236_().m_7605_((Entity)CopperGolem.this, (byte)6);
                } else if (this.pressWaitTicks <= 0 && (state = CopperGolem.this.m_9236_().m_8055_(this.blockPos)).m_60734_() instanceof CopperButtonBlock && !((Boolean)state.m_61143_((Property)CopperButtonBlock.f_51045_)).booleanValue()) {
                    ((CopperButtonBlock)state.m_60734_()).m_51116_(state, CopperGolem.this.m_9236_(), this.blockPos);
                    CopperGolem.this.m_9236_().m_5594_(null, this.blockPos, SoundEvents.f_12444_, SoundSource.BLOCKS, 0.3f, 0.6f);
                    CopperGolem.this.m_9236_().m_142346_((Entity)CopperGolem.this, GameEvent.f_223702_, this.blockPos);
                    CopperGolem.this.ticksSinceButtonPress = 80;
                }
            }
        }

        public void m_8041_() {
            CopperGolem.this.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        private void moveMobToBlock() {
            CopperGolem.this.m_21573_().m_26536_(CopperGolem.this.m_21573_().m_26524_((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_(), 0), 1.0);
        }

        private boolean findRandomButton() {
            ArrayList buttonpositions = Lists.newArrayList();
            for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(CopperGolem.this.m_20185_() - 8.0)), (int)Mth.m_14107_((double)(CopperGolem.this.m_20186_() - 4.0)), (int)Mth.m_14107_((double)(CopperGolem.this.m_20189_() - 8.0)), (int)Mth.m_14107_((double)(CopperGolem.this.m_20185_() + 8.0)), (int)Mth.m_14107_((double)(CopperGolem.this.m_20186_() + 4.0)), (int)Mth.m_14107_((double)(CopperGolem.this.m_20189_() + 8.0)))) {
                if (!CopperGolem.this.m_21444_(pos) || !this.isUnpressedButton((LevelReader)CopperGolem.this.m_9236_(), pos)) continue;
                buttonpositions.add(new BlockPos((Vec3i)pos));
            }
            if (buttonpositions.size() > 0) {
                this.blockPos = (BlockPos)buttonpositions.get(CopperGolem.this.m_217043_().m_188503_(buttonpositions.size()));
                BlockState state = CopperGolem.this.m_9236_().m_8055_(this.blockPos);
                AttachFace face = (AttachFace)state.m_61143_((Property)CopperButtonBlock.f_53179_);
                Direction direction = face == AttachFace.CEILING ? Direction.UP : (face == AttachFace.FLOOR ? Direction.DOWN : ((Direction)state.m_61143_((Property)CopperButtonBlock.f_54117_)).m_122424_());
                this.buttonNormal = direction.m_122436_();
                return true;
            }
            return false;
        }

        private boolean isUnpressedButton(LevelReader level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            BlockPos belowpos = pos.m_7495_();
            BlockState belowstate = level.m_8055_(belowpos);
            return state.m_60734_() instanceof CopperButtonBlock && (Boolean)state.m_61143_((Property)CopperButtonBlock.f_51045_) == false && belowstate.m_60634_((BlockGetter)level, belowpos, (Entity)CopperGolem.this);
        }
    }

    class RandomWalkingGoal
    extends WaterAvoidingRandomStrollGoal {
        private int walkDelay;

        public RandomWalkingGoal() {
            super((PathfinderMob)CopperGolem.this, 1.0);
        }

        public boolean m_8036_() {
            return CopperGolem.this.ticksSinceButtonPress <= 0 && super.m_8036_();
        }

        public boolean m_8045_() {
            return (this.walkDelay > 0 || !this.f_25725_.m_21573_().m_26571_()) && !this.f_25725_.m_20160_();
        }

        public void m_8056_() {
            this.walkDelay = 10;
            CopperGolem.this.spinHead();
            CopperGolem.this.m_9236_().m_7605_((Entity)CopperGolem.this, (byte)4);
        }

        public void m_8037_() {
            if (this.walkDelay > 0) {
                --this.walkDelay;
                if (this.walkDelay == 0) {
                    CopperGolem.this.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, this.f_25729_);
                }
            }
        }
    }

    class StareAtPlayerGoal
    extends LookAtPlayerGoal {
        public StareAtPlayerGoal() {
            super((Mob)CopperGolem.this, Player.class, 6.0f);
        }

        public boolean m_8036_() {
            return !CopperGolem.this.isSpinningHead() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !CopperGolem.this.isSpinningHead() && super.m_8045_();
        }
    }

    class LookAroundRandomly
    extends RandomLookAroundGoal {
        public LookAroundRandomly() {
            super((Mob)CopperGolem.this);
        }

        public boolean m_8036_() {
            return !CopperGolem.this.isSpinningHead() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !CopperGolem.this.isSpinningHead() && super.m_8045_();
        }
    }

    public static enum Oxidation {
        UNAFFECTED(0),
        EXPOSED(1),
        WEATHERED(2);

        private static final Oxidation[] VALUES;
        private final int id;

        private Oxidation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Oxidation byId(int id) {
            if (id < 0 || id >= VALUES.length) {
                id = 0;
            }
            return VALUES[id];
        }

        static {
            VALUES = (Oxidation[])Arrays.stream(Oxidation.values()).sorted(Comparator.comparingInt(Oxidation::getId)).toArray(Oxidation[]::new);
        }
    }
}

