/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CCConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue creepersDropAllBlocks;
        public final ForgeConfigSpec.BooleanValue creeperExplosionNerf;
        public final ForgeConfigSpec.DoubleValue creeperExplosionNerfFactor;
        public final ForgeConfigSpec.BooleanValue deepersDropAllBlocks;
        public final ForgeConfigSpec.IntValue deeperMaxSpawnHeight;
        public final ForgeConfigSpec.IntValue peeperMaxSpawnHeight;
        public final ForgeConfigSpec.BooleanValue chainmailArmorIncreasesDamage;
        public final ForgeConfigSpec.BooleanValue goldenArmorIncreasesSpeed;
        public final ForgeConfigSpec.BooleanValue betterRailPlacement;
        public final ForgeConfigSpec.IntValue betterRailPlacementRange;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            builder.push("creeper");
            this.creepersDropAllBlocks = builder.define("Creeper explosions drop all blocks", true);
            this.creeperExplosionNerf = builder.comment("Creeper explosions have a weaker power").define("Creeper explosion nerf", true);
            this.creeperExplosionNerfFactor = builder.comment("How much weaker Creeper explosions are").defineInRange("Creeper explosion nerf factor", 0.5, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("deeper");
            this.deepersDropAllBlocks = builder.define("Deeper explosions drop all blocks", true);
            this.deeperMaxSpawnHeight = builder.defineInRange("Deeper max spawn height", 60, -64, 320);
            builder.pop();
            builder.push("peeper");
            this.peeperMaxSpawnHeight = builder.defineInRange("Peeper max spawn height", -4, -64, 320);
            builder.pop();
            builder.pop();
            builder.push("tweaks");
            this.chainmailArmorIncreasesDamage = builder.comment("Chainmail armor increases the user's attack damage").define("Chainmail armor increases damage", true);
            this.goldenArmorIncreasesSpeed = builder.comment("Golden armor increases the user's movement speed").define("Golden armor increases speed", true);
            builder.push("rails");
            this.betterRailPlacement = builder.comment("Rails can be placed in the direction you're looking at by clicking on another rail, similar to scaffolding").define("Better rail placement", true);
            this.betterRailPlacementRange = builder.comment("The range in blocks that better rail placement can reach").defineInRange("Placement range", 7, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue compassesDisplayPosition;
        public final ForgeConfigSpec.BooleanValue depthGaugesDisplayPosition;
        public final ForgeConfigSpec.BooleanValue barometersDisplayWeather;
        public final ForgeConfigSpec.BooleanValue clocksDisplayTime;
        public final ForgeConfigSpec.BooleanValue clocksDisplayDay;
        public final ForgeConfigSpec.BooleanValue clocksUse24hrTime;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            builder.push("compass");
            this.compassesDisplayPosition = builder.comment("Compasses display X and Z coordinates in the item description").define("Compasses display position", true);
            builder.pop();
            builder.push("clock");
            this.clocksDisplayTime = builder.comment("Clocks display the time of day in the item description").define("Clocks display time", true);
            this.clocksDisplayDay = builder.comment("Clocks display the what day it is in the item description").define("Clocks display day", true);
            this.clocksUse24hrTime = builder.comment("Clocks use 24-hour time if displaying the time").define("Clocks use 24-hour time", false);
            builder.pop();
            builder.push("depth_gauge");
            this.depthGaugesDisplayPosition = builder.comment("Depth Gauges display Y coordinates in the item description").define("Depth Gauges display position", true);
            builder.pop();
            builder.push("barometer");
            this.barometersDisplayWeather = builder.comment("Barometers display the weather in the item description").define("Barometers display weather", true);
            builder.pop();
            builder.pop();
        }
    }
}

