/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.lexiconfig.classes;

import com.codinglitch.lexiconfig.LexiconfigApi;
import com.codinglitch.lexiconfig.annotations.LexiconEntry;
import java.lang.reflect.Field;
import java.util.Optional;

public class LexiconEntryData<T> {
    public final Field field;
    public final Object owner;
    public final T defaultValue;

    public LexiconEntryData(Field field, Object owner, T defaultValue) {
        this.field = field;
        this.owner = owner;
        this.defaultValue = defaultValue;
    }

    public Optional<T> get() {
        try {
            return Optional.ofNullable(this.field.get(this.owner));
        }
        catch (IllegalAccessException e) {
            LexiconfigApi.warn(e, new Object[0]);
            return Optional.empty();
        }
    }

    public void set(T value) {
        try {
            this.field.set(this.owner, value);
        }
        catch (IllegalAccessException e) {
            LexiconfigApi.warn(e, new Object[0]);
        }
    }

    public void reset() {
        this.set(this.defaultValue);
    }

    public String getName() {
        return this.field.getName();
    }

    public String getComment() {
        LexiconEntry entry = this.field.getAnnotation(LexiconEntry.class);
        if (entry == null) {
            return "";
        }
        return entry.comment();
    }

    public String getLang() {
        LexiconEntry entry = this.field.getAnnotation(LexiconEntry.class);
        if (entry == null) {
            return "";
        }
        return entry.lang();
    }
}

