/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.inventory.content;

import com.texelsaurus.minecraft.chameleon.inventory.ContainerContent;
import com.texelsaurus.minecraft.chameleon.inventory.ContainerContentSerializer;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public record PositionContent(BlockPos pos) implements ContainerContent<PositionContent>
{
    public static final ContainerContentSerializer<PositionContent> SERIALIZER = new Serializer();

    @Override
    public ContainerContentSerializer<PositionContent> serializer() {
        return SERIALIZER;
    }

    public <T extends BlockEntity> T getBlockEntity(Level level, Class<T> type) {
        if (!level.f_46443_) {
            return null;
        }
        return WorldUtils.getBlockEntity((BlockGetter)level, this.pos, type);
    }

    public static <T extends BlockEntity> T getOrNull(Optional<PositionContent> content, Level level, Class<T> type) {
        return (T)((BlockEntity)content.map(pc -> pc.getBlockEntity(level, type)).orElse(null));
    }

    private static class Serializer
    implements ContainerContentSerializer<PositionContent> {
        private Serializer() {
        }

        @Override
        @Nullable
        public PositionContent from(FriendlyByteBuf buf) {
            return new PositionContent(buf.m_130135_());
        }

        @Override
        public void to(FriendlyByteBuf buf, PositionContent content) {
            buf.m_130064_(content.pos);
        }
    }
}

