/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.logging.LogUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.sinytra.connector.loader.ConnectorLoaderModMetadata;
import org.slf4j.Logger;

public final class ConnectorModMetadataParser {
    private static final String DEFAULT_LICENSE = "All Rights Reserved";
    private static final Pattern VALID_VERSION = Pattern.compile("^\\d+.*");
    private static final Logger LOGGER = LogUtils.getLogger();

    public static IModFileInfo createForgeMetadata(IModFile modFile, ConnectorLoaderModMetadata metadata, boolean lowCode) {
        String modid = metadata.getId();
        Config config = Config.inMemory();
        config.add("modLoader", (Object)(lowCode ? "lowcodefml" : "javafml"));
        config.add("loaderVersion", (Object)"[0, )");
        List<String> licenses = metadata.getLicense().stream().map(String::trim).filter(l -> !l.isBlank()).toList();
        config.add("license", (Object)(licenses.isEmpty() ? DEFAULT_LICENSE : String.join((CharSequence)", ", metadata.getLicense())));
        config.add("properties", Map.of("metadata", metadata, "connector_transformed", true));
        config.add(List.of("modproperties", modid), metadata.getCustomValues());
        Config modListConfig = config.createSubConfig();
        modListConfig.add("modId", (Object)modid);
        String version = metadata.getNormalizedVersion();
        if (VALID_VERSION.matcher(version).matches()) {
            modListConfig.add("version", (Object)version);
        } else {
            LOGGER.warn("Ignoring invalid version for mod {} in file {}", (Object)modid, (Object)modFile.getFilePath());
        }
        modListConfig.add("displayName", (Object)metadata.getName());
        modListConfig.add("description", (Object)metadata.getDescription());
        metadata.getIconPath(-1).ifPresent(icon -> modListConfig.add("logoFile", icon));
        Predicate<String> isValidUrl = str -> {
            if (str == null) {
                return false;
            }
            try {
                new URL((String)str);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        };
        ContactInformation contact = metadata.getContact();
        contact.get("homepage").or(() -> contact.get("source")).or(() -> Optional.of(contact.asMap()).filter(m -> !m.isEmpty()).map(m -> (String)m.entrySet().iterator().next().getValue())).filter(isValidUrl).ifPresent(url -> {
            modListConfig.add("modUrl", url);
            modListConfig.add("displayURL", url);
        });
        contact.get("issues").filter(isValidUrl).ifPresent(url -> modListConfig.add("issueTrackerURL", url));
        Optional.ofNullable(metadata.getCustomValues().get("forgeUpdateJSONURL")).filter(va -> va.getType() == CustomValue.CvType.STRING).map(CustomValue::getAsString).filter(isValidUrl).ifPresent(url -> modListConfig.add("updateJSONURL", url));
        modListConfig.add("authors", (Object)metadata.getAuthors().stream().map(Person::getName).collect(Collectors.joining(", ")));
        modListConfig.add("credits", (Object)metadata.getContributors().stream().map(Person::getName).collect(Collectors.joining(", ")));
        config.add("mods", List.of(modListConfig));
        switch (metadata.getEnvironment()) {
            case CLIENT: {
                config.add("displayTest", (Object)"IGNORE_ALL_VERSION");
                break;
            }
            case SERVER: {
                config.add("displayTest", (Object)"IGNORE_SERVER_VERSION");
            }
        }
        NightConfigWrapper configurable = new NightConfigWrapper((UnmodifiableConfig)config);
        return new ModFileInfo((ModFile)modFile, (IConfigurable)configurable, f -> {}, List.of());
    }

    private ConnectorModMetadataParser() {
    }
}

