/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.stateless.StatelessGeoBlockEntity;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.NetworkUtil;

public class StatelessBlockEntityPlayAnimPacket {
    private final BlockPos blockPos;
    private final RawAnimation animation;

    public StatelessBlockEntityPlayAnimPacket(BlockPos blockPos, RawAnimation animation) {
        this.blockPos = blockPos;
        this.animation = animation;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.blockPos);
        NetworkUtil.writeRawAnimationToBuffer(this.animation, buffer);
    }

    public static StatelessBlockEntityPlayAnimPacket decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        RawAnimation animation = NetworkUtil.readRawAnimationFromBuffer(buffer);
        return new StatelessBlockEntityPlayAnimPacket(blockPos, animation);
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            GeoBlockEntity blockEntity;
            BlockEntity patt1603$temp = ClientUtils.getLevel().m_7702_(this.blockPos);
            if (patt1603$temp instanceof GeoBlockEntity && (blockEntity = (GeoBlockEntity)patt1603$temp) instanceof StatelessGeoBlockEntity) {
                StatelessGeoBlockEntity statelessAnimatable = (StatelessGeoBlockEntity)blockEntity;
                statelessAnimatable.handleClientAnimationPlay(blockEntity, 0L, this.animation);
            }
        });
    }
}

