/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public final class AccessoryNestContainerContents {
    public static final AccessoryNestContainerContents EMPTY = new AccessoryNestContainerContents(ItemStack.f_41583_, List.of());
    public static final Endec<AccessoryNestContainerContents> ENDEC = new StructEndec<AccessoryNestContainerContents>(){
        private final StructField<AccessoryNestContainerContents, List<ItemStack>> field = CodecUtils.ofCodec(ItemStack.f_41582_).listOf().fieldOf("accessories", AccessoryNestContainerContents::accessories);

        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, AccessoryNestContainerContents accessoryNestContainerContents) {
            this.field.encodeField(ctx, serializer, struct, (Object)accessoryNestContainerContents);
        }

        public AccessoryNestContainerContents decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            List data = (List)this.field.decodeField(ctx, deserializer, struct);
            return new AccessoryNestContainerContents(((AccessoriesDataComponents.StackAttribute)ctx.requireAttributeValue(AccessoriesDataComponents.StackAttribute.INSTANCE)).stack(), (List<ItemStack>)data);
        }
    };
    private final AccessoryNest accessoryNest;
    private final ItemStack stack;
    private final List<ItemStack> accessories;
    private final List<ItemStack> defensiveCopies = new ArrayList<ItemStack>();
    private CompoundTag defensiveNbtData;

    public AccessoryNestContainerContents(ItemStack stack, List<ItemStack> accessories) {
        this.accessoryNest = (AccessoryNest)AccessoriesAPI.getAccessory(stack.m_41720_());
        this.stack = stack;
        this.accessories = accessories;
        for (ItemStack accessory : this.accessories) {
            this.defensiveCopies.add(accessory.m_41777_());
        }
        if (stack.m_41782_()) {
            this.defensiveNbtData = stack.m_41783_().m_6426_();
        }
    }

    private AccessoryNestContainerContents(AccessoryNestContainerContents contents, List<ItemStack> accessories) {
        this.stack = contents.stack;
        this.accessoryNest = (AccessoryNest)AccessoriesAPI.getAccessory(this.stack.m_41720_());
        this.accessories = accessories;
    }

    public boolean hasChangesOccured(ItemStack holderStack) {
        List<ItemStack> prevStacks = this.defensiveCopies;
        List<ItemStack> currentStacks = this.accessories;
        for (int i = 0; i < prevStacks.size(); ++i) {
            ItemStack currentStack = currentStacks.get(i);
            if (ItemStack.m_41728_((ItemStack)prevStacks.get(i), (ItemStack)currentStack)) continue;
            this.accessoryNest.setInnerStack(holderStack, i, currentStack);
        }
        return true;
    }

    public final boolean isInvalid() {
        return !Objects.equals(this.stack.m_41783_(), this.defensiveNbtData);
    }

    @ApiStatus.Internal
    public AccessoryNestContainerContents setStack(int index, ItemStack stack) {
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>(this.accessories());
        accessories.set(index, stack);
        return new AccessoryNestContainerContents(this, accessories);
    }

    public Map<ItemStack, Accessory> getMap() {
        LinkedHashMap<ItemStack, Accessory> map = new LinkedHashMap<ItemStack, Accessory>();
        this.accessories().forEach(stack1 -> map.put((ItemStack)stack1, AccessoriesAPI.getOrDefaultAccessory(stack1)));
        return map;
    }

    public Map<SlotEntryReference, Accessory> getMap(SlotReference slotReference) {
        LinkedHashMap<SlotEntryReference, Accessory> map = new LinkedHashMap<SlotEntryReference, Accessory>();
        List<ItemStack> innerStacks = this.accessories();
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            if (innerStack.m_41619_()) continue;
            map.put(new SlotEntryReference(AccessoryNestUtils.create(slotReference, i), innerStack), AccessoriesAPI.getOrDefaultAccessory(innerStack));
        }
        return map;
    }

    public List<ItemStack> accessories() {
        return this.accessories;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AccessoryNestContainerContents that = (AccessoryNestContainerContents)obj;
        return Objects.equals(this.accessories, that.accessories);
    }

    public int hashCode() {
        return Objects.hash(this.accessories);
    }

    public String toString() {
        return "AccessoryNestContainerContents[accessories=" + String.valueOf(this.accessories) + "]";
    }
}

