/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import io.netty.buffer.ByteBuf;
import io.wispforest.accessories.api.slot.NestedSlotReferenceImpl;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotReferenceImpl;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;

public class SlotReferenceEncoding {
    private static final Endec<LivingEntity> LIVING_ENTITY_ENDEC = Endec.VAR_INT.xmapWithContext((ctx, id) -> {
        Level level = ((LevelAttribute)ctx.requireAttributeValue(LevelAttribute.LEVEL)).level();
        Entity entity = level.m_6815_(id.intValue());
        if (entity == null) {
            throw new IllegalStateException("Unable to locate the given entity with the following ID with the passed level! [Id: " + id + " , Level: " + String.valueOf(level.m_46472_()) + " ]");
        }
        if (!(entity instanceof LivingEntity)) {
            throw new IllegalStateException("Given entity found within the world was not of LivingEntity! [Id: " + id + ", EntityType: " + String.valueOf(entity.m_6095_()) + ", Level: " + String.valueOf(level.m_46472_()) + " ]");
        }
        LivingEntity living = (LivingEntity)entity;
        return living;
    }, (context, entity) -> entity.m_19879_());
    private static final StructEndec<NestedSlotReferenceImpl> NESTED_SLOT_REFERENCE_ENDEC = StructEndecBuilder.of((StructField)LIVING_ENTITY_ENDEC.fieldOf("entity", NestedSlotReferenceImpl::entity), (StructField)Endec.STRING.fieldOf("slotName", NestedSlotReferenceImpl::slotName), (StructField)Endec.VAR_INT.fieldOf("initialHolderSlot", NestedSlotReferenceImpl::initialHolderSlot), (StructField)Endec.VAR_INT.listOf().fieldOf("innerSlotIndices", NestedSlotReferenceImpl::innerSlotIndices), NestedSlotReferenceImpl::new);
    private static final StructEndec<SlotReferenceImpl> BASE_SLOT_REFERENCE_ENDEC = StructEndecBuilder.of((StructField)LIVING_ENTITY_ENDEC.fieldOf("entity", SlotReferenceImpl::entity), (StructField)Endec.STRING.fieldOf("slotName", SlotReferenceImpl::slotName), (StructField)Endec.VAR_INT.fieldOf("slot", SlotReferenceImpl::slot), SlotReferenceImpl::new);
    @ApiStatus.Experimental
    public static final Endec<SlotReference> ENDEC = Endec.dispatchedStruct(key -> switch (key) {
        case "nested" -> NESTED_SLOT_REFERENCE_ENDEC;
        case "base" -> BASE_SLOT_REFERENCE_ENDEC;
        default -> throw new IllegalStateException("Unable to find endec for the given SlotReference type: " + key);
    }, slotReference -> {
        if (slotReference instanceof NestedSlotReferenceImpl) {
            return "nested";
        }
        if (slotReference instanceof SlotReferenceImpl) {
            return "base";
        }
        return "";
    }, (Endec)Endec.STRING);

    public static ByteBuf encodeReference(ByteBuf byteBuf, SlotReference slotReference) {
        ENDEC.encode(SerializationContext.empty(), (Serializer)ByteBufSerializer.of((ByteBuf)byteBuf), (Object)slotReference);
        return byteBuf;
    }

    public static SlotReference decodeReference(ByteBuf byteBuf, Level level) {
        return (SlotReference)ENDEC.decode(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{new LevelAttribute(level)}), (Deserializer)ByteBufDeserializer.of((ByteBuf)byteBuf));
    }

    @ApiStatus.Experimental
    public record LevelAttribute(Level level) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<LevelAttribute> LEVEL = SerializationAttribute.withValue((String)"current_minecraft_level");

        public SerializationAttribute attribute() {
            return LEVEL;
        }

        public Object value() {
            return this;
        }
    }
}

