/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.content.KineticHelper;
import com.hlysine.create_connected.content.kineticbattery.KineticBatteryValueBox;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeBlock;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeDestinationBlockEntity;
import com.hlysine.create_connected.content.kineticbridge.StressImpactScrollValueBehaviour;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class KineticBridgeBlockEntity
extends KineticBlockEntity {
    public ScrollValueBehaviour stressMultiplier;
    private float previousStress = 0.0f;
    private float previousSpeed = 0.0f;

    public KineticBridgeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.stressMultiplier = new StressImpactScrollValueBehaviour((Component)ConnectedLang.translateDirect("kinetic_bridge.stress_impact", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new KineticBatteryValueBox(8.0));
        this.stressMultiplier.between(0, 2048);
        this.stressMultiplier.value = 40;
        this.stressMultiplier.withCallback(i -> this.updateSelfKinetic());
        behaviours.add((BlockEntityBehaviour)this.stressMultiplier);
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.updateDestinationKinetic();
    }

    public void onSpeedChanged(float previousSpeed) {
        this.updateDestinationKinetic();
        super.onSpeedChanged(previousSpeed);
    }

    public void updateSelfKinetic() {
        KineticHelper.updateKineticBlock(this);
    }

    public void updateDestinationKinetic() {
        if (this.m_58904_() == null) {
            return;
        }
        float newStress = this.calculateStressApplied();
        if (this.getSpeed() == this.previousSpeed && newStress == this.previousStress) {
            return;
        }
        BlockPos destinationPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)KineticBridgeBlock.FACING));
        BlockEntity be = this.m_58904_().m_7702_(destinationPos);
        if (!(be instanceof KineticBridgeDestinationBlockEntity)) {
            return;
        }
        KineticBridgeDestinationBlockEntity destinationBE = (KineticBridgeDestinationBlockEntity)be;
        destinationBE.updateKineticsNextTick = true;
        this.previousSpeed = this.getSpeed();
        this.previousStress = newStress;
    }

    public float calculateStressApplied() {
        this.lastStressApplied = StressImpactScrollValueBehaviour.convertValue(this.stressMultiplier.getValue());
        return this.lastStressApplied;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(1.0);
    }
}

