/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class CokeOvenLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    public static final BlockPos MASTER_OFFSET = new BlockPos(1, 1, 1);
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int EMPTY_CONTAINER_SLOT = 2;
    public static final int FULL_CONTAINER_SLOT = 3;
    public static final int NUM_SLOTS = 4;
    public static final int TANK_CAPACITY = 12000;

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        boolean activeBeforeTick;
        State state = context.getState();
        BlockState masterBlockState = context.getLevel().getBlockState(MASTER_OFFSET);
        boolean active = activeBeforeTick = ((Boolean)masterBlockState.m_61143_(NonMirrorableWithActiveBlock.ACTIVE)).booleanValue();
        if (state.process > 0) {
            if (state.inventory.getStackInSlot(0).m_41619_()) {
                state.process = 0;
                state.processMax = 0;
            } else {
                recipe = this.getRecipe(context);
                if (recipe == null || recipe.time != state.processMax) {
                    state.process = 0;
                    state.processMax = 0;
                    active = false;
                } else {
                    --state.process;
                }
            }
            context.markMasterDirty();
        } else {
            if (activeBeforeTick) {
                recipe = this.getRecipe(context);
                if (recipe != null) {
                    state.inventory.getStackInSlot(0).m_41769_(-recipe.input.getCount());
                    ItemStack outputStack = state.inventory.getStackInSlot(1);
                    if (!outputStack.m_41619_()) {
                        outputStack.m_41769_(((ItemStack)recipe.output.get()).m_41777_().m_41613_());
                    } else if (outputStack.m_41619_()) {
                        state.inventory.setStackInSlot(1, ((ItemStack)recipe.output.get()).m_41777_());
                    }
                    state.tank.fill(new FluidStack((Fluid)IEFluids.CREOSOTE.getStill(), recipe.creosoteOutput), IFluidHandler.FluidAction.EXECUTE);
                }
                state.processMax = 0;
                active = false;
            }
            if ((recipe = this.getRecipe(context)) != null) {
                state.processMax = state.process = recipe.time;
                active = true;
            }
        }
        if (state.tank.getFluidAmount() > 0 && FluidUtils.fillFluidContainer((IFluidHandler)state.tank, 2, 3, state.inventory)) {
            context.markMasterDirty();
        }
        if (active && ApiUtils.RANDOM.nextInt(24) == 0) {
            IMultiblockLevel level = context.getLevel();
            Level rawLevel = level.getRawLevel();
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            rawLevel.m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.5f + ApiUtils.RANDOM.nextFloat() * 0.5f, ApiUtils.RANDOM.nextFloat() * 0.7f + 0.3f);
        }
        if (activeBeforeTick != active) {
            NonMirrorableWithActiveBlock.setActive(context.getLevel(), IEMultiblocks.COKE_OVEN, active);
        }
    }

    @javax.annotation.Nullable
    public CokeOvenRecipe getRecipe(IMultiblockContext<State> context) {
        boolean canOutputItem;
        State state = context.getState();
        CokeOvenRecipe recipe = state.cachedRecipe.apply(context.getLevel().getRawLevel());
        if (recipe == null) {
            return null;
        }
        ItemStack currentOutputStack = state.inventory.getStackInSlot(1);
        if (currentOutputStack.m_41619_()) {
            canOutputItem = true;
        } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)currentOutputStack, (ItemStack)((ItemStack)recipe.output.get()))) {
            canOutputItem = false;
        } else {
            boolean bl = canOutputItem = currentOutputStack.m_41613_() + ((ItemStack)recipe.output.get()).m_41613_() <= 64;
        }
        if (canOutputItem && state.tank.getFluidAmount() + recipe.creosoteOutput <= state.tank.getCapacity()) {
            return recipe;
        }
        return null;
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return state.invCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return state.fluidCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return $ -> Shapes.m_83144_();
    }

    public static class State
    implements IMultiblockState,
    ContainerData {
        public static final int MAX_BURN_TIME = 0;
        public static final int BURN_TIME = 1;
        public static final int NUM_SLOTS = 2;
        private final FluidTank tank = new FluidTank(12000);
        private final SlotwiseItemHandler inventory;
        private final Function<Level, CokeOvenRecipe> cachedRecipe;
        private int process = 0;
        private int processMax = 0;
        private final StoredCapability<IItemHandler> invCap;
        private final StoredCapability<IFluidHandler> fluidCap;

        public State(IInitialMultiblockContext<State> ctx) {
            Supplier<@Nullable Level> levelGetter = ctx.levelSupplier();
            this.inventory = new SlotwiseItemHandler(List.of(SlotwiseItemHandler.IOConstraint.input(i -> CokeOvenRecipe.findRecipe((Level)levelGetter.get(), i) != null), SlotwiseItemHandler.IOConstraint.OUTPUT, SlotwiseItemHandler.IOConstraint.FLUID_INPUT, SlotwiseItemHandler.IOConstraint.OUTPUT), ctx.getMarkDirtyRunnable());
            this.cachedRecipe = CachedRecipe.cachedSkip1(CokeOvenRecipe::findRecipe, () -> this.inventory.getStackInSlot(0));
            this.invCap = new StoredCapability<SlotwiseItemHandler>(this.inventory);
            this.fluidCap = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler(new IFluidTank[]{this.tank}, true, false, ctx.getMarkDirtyRunnable()));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128405_("process", this.process);
            nbt.m_128405_("processMax", this.processMax);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.process = nbt.m_128451_("process");
            this.processMax = nbt.m_128451_("processMax");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> this.processMax;
                case 1 -> this.process;
                default -> throw new IllegalArgumentException("Unknown index " + index);
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    this.processMax = value;
                    break;
                }
                case 1: {
                    this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 2;
        }

        public FluidTank getTank() {
            return this.tank;
        }

        public SlotwiseItemHandler getInventory() {
            return this.inventory;
        }
    }
}

