/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;

public interface ProcessContext<R extends MultiblockRecipe> {
    public static final int[] EMPTY_INTS = new int[0];
    public static final IItemHandlerModifiable EMPTY_ITEM_HANDLER = new EmptyHandler();
    public static final IFluidTank[] EMPTY_TANKS = new IFluidTank[0];

    public AveragingEnergyStorage getEnergy();

    default public IItemHandlerModifiable getInventory() {
        return EMPTY_ITEM_HANDLER;
    }

    default public IFluidTank[] getInternalTanks() {
        return EMPTY_TANKS;
    }

    default public boolean additionalCanProcessCheck(MultiblockProcess<R, ?> process, Level level) {
        return true;
    }

    default public void onProcessFinish(MultiblockProcess<R, ?> process, Level level) {
    }

    public static interface ProcessContextInMachine<R extends MultiblockRecipe>
    extends ProcessContext<R> {
        default public int[] getOutputTanks() {
            return EMPTY_INTS;
        }

        default public int[] getOutputSlots() {
            return EMPTY_INTS;
        }
    }

    public static interface ProcessContextInWorld<R extends MultiblockRecipe>
    extends ProcessContext<R> {
        default public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            throw new RuntimeException("Should be implemented in machines that output items!");
        }

        default public void doProcessFluidOutput(FluidStack output) {
            throw new RuntimeException("Should be implemented in machines that output fluids!");
        }
    }
}

