/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.mixin;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.invoke.InvokeInjector;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.util.Bytecode;

public class CaptureOwnerInjector
extends InvokeInjector {
    public CaptureOwnerInjector(InjectionInfo info) {
        super(info, "@CaptureOwner");
    }

    protected void sanityCheck(Target target, List<InjectionPoint> injectionPoints) {
        super.sanityCheck(target, injectionPoints);
        if (this.methodArgs.length == 0 || this.methodArgs.length > 1 + target.arguments.length) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "Target for CaptureOwner must take one arg (the owner to capture/modify) and then some prefix of the target argument");
        }
        if (!Objects.equals(this.returnType, this.methodArgs[0])) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "Target for CaptureOwner must return the type of the modified argument, not " + this.returnType);
        }
        for (int i = 1; i < this.methodArgs.length; ++i) {
            if (Objects.equals(this.methodArgs[i], target.arguments[i - 1])) continue;
            throw new InvalidInjectionException((ISelectorContext)this.info, "Argument " + i + " must be (i-1)th arg of target: " + this.methodArgs[i] + " vs " + target.arguments[i - 1]);
        }
    }

    protected void injectAtInvoke(Target target, InjectionNodes.InjectionNode node) {
        MethodInsnNode invokedNode = (MethodInsnNode)node.getCurrentTarget();
        Type[] realArgs = Type.getArgumentTypes((String)invokedNode.desc);
        Type[] argsWithThis = new Type[realArgs.length + 1];
        argsWithThis[0] = Type.getType((String)("L" + invokedNode.owner + ";"));
        System.arraycopy(realArgs, 0, argsWithThis, 1, realArgs.length);
        InsnList injected = new InsnList();
        Target.Extension extraLocals = target.extendLocals();
        int[] storedArgs = this.storeArgs(target, argsWithThis, injected, 0);
        if (!this.isStatic) {
            injected.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        this.pushArgs(argsWithThis, injected, storedArgs, 0, 1);
        int firstMethodArg = this.isStatic ? 0 : 1;
        Bytecode.loadArgs((Type[])Arrays.copyOf(target.arguments, this.methodArgs.length - 1), (InsnList)injected, (int)firstMethodArg, (int)-1);
        this.invokeHandler(injected);
        injected.add((AbstractInsnNode)new TypeInsnNode(192, invokedNode.owner));
        this.pushArgs(argsWithThis, injected, storedArgs, 1, storedArgs.length);
        extraLocals.add(storedArgs[storedArgs.length - 1] - target.getMaxLocals());
        target.insns.insertBefore((AbstractInsnNode)invokedNode, injected);
        target.extendStack().set(2 - (extraLocals.get() - 1)).apply();
        extraLocals.apply();
    }
}

