/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing.common.advancements.criterion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import fuffles.tactical_fishing.common.item.crafting.FishingRecipe;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipePredicate {
    private static final Fishing ANY = new Fishing(null, null, (NonNullList<Ingredient>)NonNullList.m_122779_(), null);
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;

    private RecipePredicate(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result) {
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
    }

    protected boolean innerMatches(Recipe<? extends Container> recipe) {
        if (this.id != null && !this.id.equals((Object)recipe.m_6423_())) {
            return false;
        }
        if (this.group != null && !this.group.equals(recipe.m_6076_())) {
            return false;
        }
        if (this.result != null && !ItemStack.m_41728_((ItemStack)this.result, (ItemStack)recipe.m_8043_(null))) {
            return false;
        }
        if (this.ingredients.size() > 0) {
            for (Ingredient predicateIngredient : this.ingredients) {
                if (recipe.m_7527_().contains((Object)predicateIngredient)) continue;
                return false;
            }
        }
        return true;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObj = new JsonObject();
        if (this.id != null) {
            jsonObj.addProperty("id", this.id.toString());
        }
        if (this.group != null) {
            jsonObj.addProperty("group", this.group);
        }
        if (this.ingredients.size() > 0) {
            // empty if block
        }
        if (this.result != null) {
            jsonObj.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_()).toString());
        }
        return jsonObj;
    }

    public static class Fishing
    extends RecipePredicate {
        public Fishing(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result) {
            super(id, group, ingredients, result);
        }

        public boolean matches(FishingRecipe recipe) {
            return this.innerMatches(recipe);
        }

        public static Fishing fromJson(@Nullable JsonElement json) {
            if (json != null && !json.isJsonNull()) {
                JsonObject jsonObj = GsonHelper.m_13918_((JsonElement)json, (String)"recipe");
                String rawId = GsonHelper.m_13851_((JsonObject)jsonObj, (String)"id", null);
                ResourceLocation id = rawId == null ? null : new ResourceLocation(rawId);
                String group = GsonHelper.m_13851_((JsonObject)jsonObj, (String)"group", null);
                JsonArray rawIngredients = GsonHelper.m_13832_((JsonObject)jsonObj, (String)"ingredients", null);
                NonNullList ingredients = NonNullList.m_122779_();
                JsonObject rawResult = GsonHelper.m_13841_((JsonObject)jsonObj, (String)"result", null);
                ItemStack result = rawResult == null ? null : ShapedRecipe.m_151274_((JsonObject)rawResult);
                return new Fishing(id, group, (NonNullList<Ingredient>)ingredients, result);
            }
            return ANY;
        }
    }
}

